/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.CodeHelper;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class CapabilityTransition
extends TopDownTransitionTestCase {
    private CapabilityRealizationPkg laRootCRPkg;
    private CapabilityRealizationPkg laSubCRPkg;
    private CapabilityRealization laCR1;
    private CapabilityRealization laCR2;
    private CapabilityRealization laCR11;
    private CapabilityRealization laCR3;
    private CapabilityRealization laSubCR1;
    private CapabilityRealizationPkg paRootCRPkg;
    private CapabilityRealizationPkg paSubCRPkg;
    private CapabilityRealization paCR1;
    private CapabilityRealization paCR11;
    private CapabilityRealization paCR2;
    private CapabilityRealization paCR3;
    private CapabilityRealization paSubCR1;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laRootCRPkg = (CapabilityRealizationPkg)this.getObject(ModelLaPa.rootLACRPkgId);
        this.laCR1 = (CapabilityRealization)this.getObject(ModelLaPa.CR1Id);
        this.laCR2 = (CapabilityRealization)this.getObject(ModelLaPa.CR2Id);
        this.laCR11 = (CapabilityRealization)this.getObject(ModelLaPa.CR11Id);
        this.paRootCRPkg = (CapabilityRealizationPkg)this.getObject(ModelLaPa.rootPACRPkgId);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this.initSession();
        this.CR11TransitionTest();
        this.rootCRPkgProjection1Test();
        this.rootcapaPkgProjection2Test();
        this.rootcapaPkgProjection3Test();
    }

    private void CR11TransitionTest() {
        this.performCapabilityTransition(Arrays.asList(this.laCR11));
        this.paCR11 = (CapabilityRealization)this.paRootCRPkg.getOwnedCapabilityRealizations().get(0);
        this.mustNotBeNull((EObject)this.laCR11);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR11.getName(), (Object)this.laCR11.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR11) == this.laCR11 ? 1 : 0) != 0);
    }

    private void rootCRPkgProjection1Test() {
        this.performCapabilityTransition(Arrays.asList(this.laRootCRPkg));
        this.paCR1 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this.paRootCRPkg, (EObject)this.laCR1);
        this.mustNotBeNull((EObject)this.paCR1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this.laCR1.getName()), (this.laCR1.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this.paCR1.getName()), (this.paCR1.eContainer() == this.paRootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR1.getName(), (Object)this.laCR1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR1) == this.laCR1 ? 1 : 0) != 0);
        this.paCR2 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this.paRootCRPkg, (EObject)this.laCR2);
        this.mustNotBeNull((EObject)this.paCR2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this.laCR2.getName()), (this.laCR2.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this.paCR2.getName()), (this.paCR2.eContainer() == this.paRootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR2.getName(), (Object)this.laCR2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR2) == this.laCR2 ? 1 : 0) != 0);
    }

    private void rootcapaPkgProjection2Test() {
        this.performCapabilityTransition(Arrays.asList(this.laRootCRPkg));
        int laSize = this.laRootCRPkg.getOwnedCapabilityRealizations().size();
        int paSize = this.paRootCRPkg.getOwnedCapabilityRealizations().size();
        CapabilityTransition.assertTrue((String)Messages.WrongSize, (laSize == paSize ? 1 : 0) != 0);
    }

    private void rootcapaPkgProjection3Test() {
        this.laCR2.destroy();
        this.laCR3 = LaFactory.eINSTANCE.createCapabilityRealization("CR3");
        this.laRootCRPkg.getOwnedCapabilityRealizations().add((Object)this.laCR3);
        this.laSubCRPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg("SubCRPkg");
        this.laRootCRPkg.getOwnedCapabilityRealizationPkgs().add((Object)this.laSubCRPkg);
        this.laSubCR1 = LaFactory.eINSTANCE.createCapabilityRealization("SubCR1");
        this.laSubCRPkg.getOwnedCapabilityRealizations().add((Object)this.laSubCR1);
        this.performCapabilityTransition(Arrays.asList(this.laRootCRPkg));
        this.mustNotBeNull((EObject)this.paCR2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR2.getName(), (Object)this.laCR2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR2) == null ? 1 : 0) != 0);
        this.paCR3 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this.paRootCRPkg, (EObject)this.laCR3);
        this.mustNotBeNull((EObject)this.paCR3);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this.laCR3.getName()), (this.laCR3.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this.paCR3.getName()), (this.paCR3.eContainer() == this.paRootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paCR3.getName(), (Object)this.laCR3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paCR3) == this.laCR3 ? 1 : 0) != 0);
        this.paSubCRPkg = (CapabilityRealizationPkg)this.paRootCRPkg.getOwnedCapabilityRealizationPkgs().get(0);
        this.mustNotBeNull((EObject)this.paSubCRPkg);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubCRPkg.getName(), (Object)this.laSubCRPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubCRPkg) == this.laSubCRPkg ? 1 : 0) != 0);
        this.paSubCR1 = (CapabilityRealization)this.paSubCRPkg.getOwnedCapabilityRealizations().get(0);
        this.mustNotBeNull((EObject)this.paSubCR1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubCR1.getName(), (Object)this.laSubCR1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubCR1) == this.laSubCR1 ? 1 : 0) != 0);
    }
}

