/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLcPc;

public class LCPCBreakdownWithItf
extends TopDownTransitionTestCase {
    private LogicalComponent logicalSystem;
    private LogicalComponent lc1;
    private LogicalComponent lc11;
    private LogicalComponent lc111;
    private LogicalComponent lc12;
    private LogicalComponent lc2;
    private LogicalComponent lc21;
    private LogicalComponent lc22;
    private LogicalComponent leafLC;
    private LogicalComponentPkg lcPkg;
    private LogicalComponent subLC1;
    private LogicalComponent subLC11;
    private LogicalComponent subLC12;
    private ComponentExchange logicalConnection1;
    private ComponentPort lc1OFP;
    private ComponentPort lc2IFP;
    private ComponentExchange logicalConnection2;
    private ComponentPort lc11OFP;
    private ComponentPort lc12IFP;
    private ComponentExchange logicalConnection3;
    private ComponentPort lc21OFP;
    private ComponentPort lc22IFP;
    private ComponentExchange logicalConnection4;
    private InterfacePkg logicalInterfacePkg;
    private InterfacePkg lsInterfacePkg;
    private Interface logicalInterface1;
    private Interface logicalInterface2;
    private LogicalFunction lf11;
    private FunctionInputPort lf11FIP;
    private LogicalFunction lf111;
    private FunctionOutputPort lf111FOP;
    private AbstractFunction logicalJoin1;
    private FunctionalExchange lf111Join1Exchange;
    private FunctionalExchange join1LF11Exchange;
    private Interface logicalExternalItf1;
    private Interface logicalExternalItf2;
    private PhysicalComponent physicalSystem;
    private PhysicalComponent pc1;
    private PhysicalComponent pc11;
    private PhysicalComponent pc111;
    private PhysicalComponent pc12;
    private PhysicalComponent pc2;
    private PhysicalComponent pc21;
    private PhysicalComponent pc22;
    private PhysicalComponent leafPC;
    private PhysicalComponentPkg pcPkg;
    private PhysicalComponent subPC1;
    private PhysicalComponent subPC11;
    private PhysicalComponent subPC12;
    private ComponentExchange physicalConnection1;
    private ComponentPort pc1OFP;
    private ComponentPort pc2IFP;
    private ComponentExchange physicalConnection2;
    private ComponentPort pc11OFP;
    private ComponentPort pc12IFP;
    private ComponentExchange physicalConnection3;
    private ComponentPort pc21OFP;
    private ComponentPort pc22IFP;
    private ComponentExchange physicalConnection4;
    private InterfacePkg psInterfacePkg;
    private Interface physicalInterface1;
    private Interface physicalInterface2;
    private PhysicalFunction pf11;
    private FunctionInputPort pf11FIP;
    private PhysicalFunction pf111;
    private FunctionOutputPort pf111FOP;
    private AbstractFunction physicalJoin1;
    private FunctionalExchange pf111Join1Exchange;
    private FunctionalExchange join1PF11Exchange;
    private Interface physicalExternalItf1;
    private Interface physicalExternalItf2;
    private PhysicalComponentPkg physicalActorPkg;
    private PhysicalFunction rootPF;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.setPreferenceValue("interface.mode", true);
        this.setPreferenceValue("projection.lcpc.mode", "2");
        this.logicalSystem = (LogicalComponent)this.getObject(ModelLcPc.logicalSystemId);
        this.lc1 = (LogicalComponent)this.getObject(ModelLcPc.lc1Id);
        this.lc11 = (LogicalComponent)this.getObject(ModelLcPc.lc11Id);
        this.lc111 = (LogicalComponent)this.getObject(ModelLcPc.lc111Id);
        this.lc12 = (LogicalComponent)this.getObject(ModelLcPc.lc12Id);
        this.lc2 = (LogicalComponent)this.getObject(ModelLcPc.lc2Id);
        this.lc21 = (LogicalComponent)this.getObject(ModelLcPc.lc21Id);
        this.lc22 = (LogicalComponent)this.getObject(ModelLcPc.lc22Id);
        this.leafLC = (LogicalComponent)this.getObject(ModelLcPc.leafLCId);
        this.lcPkg = (LogicalComponentPkg)this.getObject(ModelLcPc.lcPkgId);
        this.subLC1 = (LogicalComponent)this.getObject(ModelLcPc.subLC1Id);
        this.subLC11 = (LogicalComponent)this.getObject(ModelLcPc.subLC11Id);
        this.logicalConnection1 = (ComponentExchange)this.getObject(ModelLcPc.connection1Id);
        this.lc1OFP = (ComponentPort)this.getObject(ModelLcPc.lc1OFPId);
        this.lc2IFP = (ComponentPort)this.getObject(ModelLcPc.lc2IFPId);
        this.logicalConnection2 = (ComponentExchange)this.getObject(ModelLcPc.connection2Id);
        this.lc11OFP = (ComponentPort)this.getObject(ModelLcPc.lc11OFPId);
        this.lc12IFP = (ComponentPort)this.getObject(ModelLcPc.lc12IFPId);
        this.logicalConnection3 = (ComponentExchange)this.getObject(ModelLcPc.connection3Id);
        this.lc21OFP = (ComponentPort)this.getObject(ModelLcPc.lc21OFPId);
        this.lc22IFP = (ComponentPort)this.getObject(ModelLcPc.lc22IFPId);
        this.logicalConnection4 = (ComponentExchange)this.getObject(ModelLcPc.connection4Id);
        this.lsInterfacePkg = (InterfacePkg)this.getObject(ModelLcPc.lsInterfacePkgId);
        this.logicalInterfacePkg = (InterfacePkg)this.getObject(ModelLcPc.logicalInterfacePkgId);
        this.logicalInterface1 = (Interface)this.getObject(ModelLcPc.interface1Id);
        this.logicalInterface2 = (Interface)this.getObject(ModelLcPc.interface2Id);
        this.lf11 = (LogicalFunction)this.getObject(ModelLcPc.lf11Id);
        this.lf11FIP = (FunctionInputPort)this.getObject(ModelLcPc.lf11FIPId);
        this.lf111 = (LogicalFunction)this.getObject(ModelLcPc.lf111Id);
        this.lf111FOP = (FunctionOutputPort)this.getObject(ModelLcPc.lf111FOPId);
        this.logicalJoin1 = (AbstractFunction)this.getObject(ModelLcPc.join1Id);
        this.lf111Join1Exchange = (FunctionalExchange)this.getObject(ModelLcPc.lf111Join1ExchangeId);
        this.join1LF11Exchange = (FunctionalExchange)this.getObject(ModelLcPc.join1LF11ExchangeId);
        this.logicalExternalItf1 = (Interface)this.getObject(ModelLcPc.externalItf1Id);
        this.logicalExternalItf2 = (Interface)this.getObject(ModelLcPc.externalItf2Id);
        this.physicalSystem = (PhysicalComponent)this.getObject(ModelLcPc.physicalSystemId);
        this.physicalActorPkg = (PhysicalComponentPkg)this.getObject(ModelLcPc.physicalActorPkgId);
        this.rootPF = (PhysicalFunction)this.getObject(ModelLcPc.rootPFId);
    }

    public void performTest() throws Exception {
        this.initSession();
        this.leafLCTransitionTest();
        this.lc1Transition1Test();
        this.lc1Transition2Test();
        this.logicalSystemTransitionTest();
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    private void leafLCTransitionTest() {
        this.performLCtoPCTransition(Arrays.asList(this.logicalSystem));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalSystem.getName(), (Object)this.logicalSystem.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalSystem) == this.logicalSystem ? 1 : 0) != 0);
        this.psInterfacePkg = this.physicalSystem.getOwnedInterfacePkg();
        this.mustNotBeNull((EObject)this.psInterfacePkg);
        int projectedIntSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedIntSize), (int)projectedIntSize, (int)this.psInterfacePkg.getOwnedInterfaces().size());
        EList physicalActors = this.physicalActorPkg.getOwnedPhysicalComponents();
        LCPCBreakdownWithItf.assertTrue((String)Messages.ErrorMessage, (physicalActors.size() == 1 ? 1 : 0) != 0);
        this.leafPC = this.testAndGetProjectedPC(this.leafLC);
        this.pc1 = this.testAndGetProjectedPC(this.lc1);
        this.pc11 = this.testAndGetProjectedPC(this.lc11);
        this.pc12 = this.testAndGetProjectedPC(this.lc12);
        this.pc111 = this.testAndGetProjectedPC(this.lc111);
        this.pc2 = this.testAndGetProjectedPC(this.lc2);
        this.pc21 = this.testAndGetProjectedPC(this.lc21);
        this.pc22 = this.testAndGetProjectedPC(this.lc22);
        this.pcPkg = (PhysicalComponentPkg)this.physicalSystem.getOwnedPhysicalComponentPkgs().get(0);
        this.mustNotBeNull((EObject)this.pcPkg);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pcPkg.getName(), (Object)this.lcPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pcPkg) == this.lcPkg ? 1 : 0) != 0);
        this.subPC1 = this.testAndGetProjectedPC(this.subLC1);
        this.subPC11 = this.testAndGetProjectedPC(this.subLC11);
        LCPCBreakdownWithItf.assertNotNull((Object)this.leafPC);
        LCPCBreakdownWithItf.assertNotNull((Object)this.subPC1);
        LCPCBreakdownWithItf.assertNotNull((Object)this.subPC11);
        this.pf11 = (PhysicalFunction)this.testAndGetProjectedPF((AbstractFunction)this.lf11);
        this.pf11FIP = (FunctionInputPort)this.pf11.getInputs().get(0);
        this.mustNotBeNull((EObject)this.pf11FIP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pf11FIP.getName(), (Object)this.lf11FIP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf11FIP) == this.lf11FIP ? 1 : 0) != 0);
        this.pf111 = (PhysicalFunction)this.testAndGetProjectedPF((AbstractFunction)this.lf111);
        this.mustNotBeNull((EObject)this.pf111);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pf111.getName(), (Object)this.lf111.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf111) == this.lf111 ? 1 : 0) != 0);
        this.pf111FOP = (FunctionOutputPort)this.pf111.getOutputs().get(0);
        this.mustNotBeNull((EObject)this.pf111FOP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pf111FOP.getName(), (Object)this.lf111FOP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf111FOP) == this.lf111FOP ? 1 : 0) != 0);
        this.physicalJoin1 = this.testAndGetProjectedPF(this.logicalJoin1);
        this.pf111Join1Exchange = (FunctionalExchange)this.physicalJoin1.getIncoming().get(0);
        this.mustNotBeNull((EObject)this.pf111Join1Exchange);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pf111Join1Exchange.getName(), (Object)this.lf111Join1Exchange.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf111Join1Exchange) == this.lf111Join1Exchange ? 1 : 0) != 0);
        this.join1PF11Exchange = (FunctionalExchange)this.physicalJoin1.getOutgoing().get(0);
        this.mustNotBeNull((EObject)this.join1PF11Exchange);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.join1PF11Exchange.getName(), (Object)this.join1LF11Exchange.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.join1PF11Exchange) == this.join1LF11Exchange ? 1 : 0) != 0);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.pf11.getName(), (Object)this.pc11.getName()), (boolean)this.pc11.getAllocatedFunctions().contains((Object)this.pf11));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.pf111.getName(), (Object)this.pc111.getName()), (boolean)this.pc111.getAllocatedFunctions().contains((Object)this.pf111));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.physicalJoin1.getName(), (Object)this.pc12.getName()), (boolean)this.pc12.getAllocatedFunctions().contains((Object)this.physicalJoin1));
        this.physicalConnection1 = ProjectionTestUtils.getAllocatingComponentExchange(this.logicalConnection1);
        this.mustNotBeNull((EObject)this.physicalConnection1);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalConnection1.getName(), (Object)this.logicalConnection1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalConnection1) == this.logicalConnection1 ? 1 : 0) != 0);
        this.pc1OFP = (ComponentPort)ProjectionTestUtils.getAllocatingPort((Port)this.lc1OFP);
        this.mustNotBeNull((EObject)this.pc1OFP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pc1OFP.getName(), (Object)this.lc1OFP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pc1OFP) == this.lc1OFP ? 1 : 0) != 0);
        this.pc2IFP = (ComponentPort)ProjectionTestUtils.getAllocatingPort((Port)this.lc2IFP);
        this.mustNotBeNull((EObject)this.pc2IFP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pc2IFP.getName(), (Object)this.lc2IFP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pc2IFP) == this.lc2IFP ? 1 : 0) != 0);
        this.physicalConnection2 = ProjectionTestUtils.getAllocatingComponentExchange(this.logicalConnection2);
        this.mustNotBeNull((EObject)this.physicalConnection2);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalConnection2.getName(), (Object)this.logicalConnection2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalConnection2) == this.logicalConnection2 ? 1 : 0) != 0);
        this.pc11OFP = (ComponentPort)ProjectionTestUtils.getAllocatingPort((Port)this.lc11OFP);
        this.mustNotBeNull((EObject)this.pc11OFP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pc11OFP.getName(), (Object)this.lc11OFP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pc11OFP) == this.lc11OFP ? 1 : 0) != 0);
        this.pc12IFP = (ComponentPort)ProjectionTestUtils.getAllocatingPort((Port)this.lc12IFP);
        this.mustNotBeNull((EObject)this.pc12IFP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pc12IFP.getName(), (Object)this.lc12IFP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pc12IFP) == this.lc12IFP ? 1 : 0) != 0);
        this.physicalConnection3 = ProjectionTestUtils.getAllocatingComponentExchange(this.logicalConnection3);
        this.mustNotBeNull((EObject)this.physicalConnection3);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalConnection3.getName(), (Object)this.logicalConnection3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalConnection3) == this.logicalConnection3 ? 1 : 0) != 0);
        this.pc21OFP = (ComponentPort)ProjectionTestUtils.getAllocatingPort((Port)this.lc21OFP);
        this.mustNotBeNull((EObject)this.pc21OFP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pc21OFP.getName(), (Object)this.lc21OFP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pc21OFP) == this.lc21OFP ? 1 : 0) != 0);
        this.pc22IFP = (ComponentPort)ProjectionTestUtils.getAllocatingPort((Port)this.lc22IFP);
        this.mustNotBeNull((EObject)this.pc22IFP);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.pc22IFP.getName(), (Object)this.lc22IFP.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pc22IFP) == this.lc22IFP ? 1 : 0) != 0);
        this.physicalConnection4 = ProjectionTestUtils.getAllocatingComponentExchange(this.logicalConnection4);
        LCPCBreakdownWithItf.assertNull((String)"Shall be null", (Object)this.physicalConnection4);
        this.physicalInterface1 = ProjectionTestUtils.getAllocatingInterface(this.logicalInterface1);
        this.mustNotBeNull((EObject)this.physicalInterface1);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalInterface1.getName(), (Object)this.logicalInterface1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalInterface1) == this.logicalInterface1 ? 1 : 0) != 0);
        this.physicalInterface2 = ProjectionTestUtils.getAllocatingInterface(this.logicalInterface2);
        this.mustNotBeNull((EObject)this.physicalInterface2);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalInterface2.getName(), (Object)this.logicalInterface2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalInterface2) == this.logicalInterface2 ? 1 : 0) != 0);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc1.getName(), (Object)this.physicalInterface1.getName()), (boolean)this.pc1.getImplementedInterfaces().contains((Object)this.physicalInterface1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc1.getName(), (Object)this.physicalInterface2.getName()), (boolean)this.pc1.getImplementedInterfaces().contains((Object)this.physicalInterface2));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc11.getName(), (Object)this.physicalInterface1.getName()), (boolean)this.pc11.getImplementedInterfaces().contains((Object)this.physicalInterface1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc12.getName(), (Object)this.physicalInterface2.getName()), (boolean)this.pc12.getImplementedInterfaces().contains((Object)this.physicalInterface2));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc2.getName(), (Object)this.physicalInterface1.getName()), (boolean)this.pc2.getUsedInterfaces().contains((Object)this.physicalInterface1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc2.getName(), (Object)this.physicalInterface2.getName()), (boolean)this.pc2.getUsedInterfaces().contains((Object)this.physicalInterface2));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc21.getName(), (Object)this.physicalInterface1.getName()), (boolean)this.pc21.getUsedInterfaces().contains((Object)this.physicalInterface1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc22.getName(), (Object)this.physicalInterface2.getName()), (boolean)this.pc22.getUsedInterfaces().contains((Object)this.physicalInterface2));
    }

    private PhysicalComponent testAndGetProjectedPC(LogicalComponent logicalComponent_p) {
        PhysicalComponent physicalComponent = (PhysicalComponent)ProjectionTestUtils.getAllocatingComponent((Component)logicalComponent_p);
        this.mustNotBeNull((EObject)physicalComponent);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)physicalComponent.getName(), (Object)logicalComponent_p.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)physicalComponent) == logicalComponent_p ? 1 : 0) != 0);
        return physicalComponent;
    }

    private AbstractFunction testAndGetProjectedPF(AbstractFunction logicalFunction_p) {
        AbstractFunction physicalFunction = ProjectionTestUtils.getAllocatingFunction(logicalFunction_p);
        this.mustNotBeNull((EObject)physicalFunction);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)physicalFunction.getName(), (Object)logicalFunction_p.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)physicalFunction) == logicalFunction_p ? 1 : 0) != 0);
        return physicalFunction;
    }

    private void lc1Transition1Test() {
        boolean test;
        TraceableElement tgt;
        this.performLCtoPCTransition(Arrays.asList(this.lc1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalSystem.getName(), (Object)this.logicalSystem.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalSystem) == this.logicalSystem ? 1 : 0) != 0);
        this.psInterfacePkg = this.physicalSystem.getOwnedInterfacePkg();
        this.mustNotBeNull((EObject)this.psInterfacePkg);
        int projectedIntSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedIntSize), (int)projectedIntSize, (int)this.psInterfacePkg.getOwnedInterfaces().size());
        EList outgoing = this.psInterfacePkg.getOutgoingTraces();
        for (AbstractTrace trace : outgoing) {
            tgt = trace.getTargetElement();
            test = tgt != null && tgt == this.logicalInterfacePkg || tgt == this.logicalSystem || tgt == this.lsInterfacePkg;
            LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.psInterfacePkg.getName(), (Object)(String.valueOf(this.logicalInterfacePkg.getName()) + "or" + this.logicalSystem.getName())), (boolean)test);
        }
        outgoing = this.psInterfacePkg.getOutgoingTraces();
        for (AbstractTrace trace : outgoing) {
            tgt = trace.getTargetElement();
            test = tgt == this.lsInterfacePkg;
            LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.psInterfacePkg.getName(), (Object)this.lsInterfacePkg.getName()), (boolean)test);
        }
        EList physicalActors = this.physicalActorPkg.getOwnedPhysicalComponents();
        LCPCBreakdownWithItf.assertTrue((String)Messages.ErrorMessage, (physicalActors.size() == 1 ? 1 : 0) != 0);
        int projectedPCSize = 3;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)projectedPCSize, (int)this.physicalSystem.getOwnedPhysicalComponents().size());
        projectedPCSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)projectedPCSize, (int)this.pc1.getOwnedPhysicalComponents().size());
        projectedPCSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)projectedPCSize, (int)this.pc2.getOwnedPhysicalComponents().size());
        int projectedPFSize = 3;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPFSize), (int)this.rootPF.getSubFunctions().size(), (int)projectedPFSize);
        int projectedExchangeSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedExchangeSize), (int)this.rootPF.getOwnedFunctionalExchanges().size(), (int)projectedExchangeSize);
    }

    private void lc1Transition2Test() {
        this.performLCtoPCTransition(Arrays.asList(this.lc1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalSystem.getName(), (Object)this.logicalSystem.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalSystem) == this.logicalSystem ? 1 : 0) != 0);
        this.psInterfacePkg = this.physicalSystem.getOwnedInterfacePkg();
        this.mustNotBeNull((EObject)this.psInterfacePkg);
        int projectedIntSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedIntSize), (int)projectedIntSize, (int)this.psInterfacePkg.getOwnedInterfaces().size());
        EList outgoing = this.psInterfacePkg.getOutgoingTraces();
        for (AbstractTrace trace : outgoing) {
            TraceableElement tgt = trace.getTargetElement();
            boolean test = tgt != null && tgt == this.logicalInterfacePkg || tgt == this.logicalSystem || tgt == this.lsInterfacePkg;
            LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.psInterfacePkg.getName(), (Object)(String.valueOf(this.logicalInterfacePkg.getName()) + "or" + this.logicalSystem.getName())), (boolean)test);
        }
        EList physicalActors = this.physicalActorPkg.getOwnedPhysicalComponents();
        LCPCBreakdownWithItf.assertTrue((String)Messages.ErrorMessage, (physicalActors.size() == 1 ? 1 : 0) != 0);
        int projectedPCSize = 3;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)this.physicalSystem.getOwnedPhysicalComponents().size(), (int)projectedPCSize);
        projectedPCSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)this.pc1.getOwnedPhysicalComponents().size(), (int)projectedPCSize);
        projectedPCSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)this.pc2.getOwnedPhysicalComponents().size(), (int)projectedPCSize);
        int projectedPFSize = 3;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPFSize), (int)this.rootPF.getSubFunctions().size(), (int)projectedPFSize);
        int projectedExchangeSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedExchangeSize), (int)this.rootPF.getOwnedFunctionalExchanges().size(), (int)projectedExchangeSize);
    }

    private void logicalSystemTransitionTest() {
        boolean test;
        TraceableElement tgt;
        this.lf111Join1Exchange.destroy();
        this.lf111FOP.destroy();
        this.lf111.destroy();
        this.subLC12 = LaFactory.eINSTANCE.createLogicalComponent("SubLC 12");
        this.subLC1.getOwnedLogicalComponents().add((Object)this.subLC12);
        Part subLC12Part = CsFactory.eINSTANCE.createPart("SubLC12:SubLC12");
        this.subLC1.getOwnedFeatures().add((Object)subLC12Part);
        subLC12Part.setAbstractType((AbstractType)this.subLC12);
        InterfaceImplementation interImpl1 = CsFactory.eINSTANCE.createInterfaceImplementation();
        interImpl1.setImplementedInterface(this.logicalExternalItf1);
        this.lc22.getOwnedInterfaceImplementations().add((Object)interImpl1);
        InterfaceImplementation interImpl2 = CsFactory.eINSTANCE.createInterfaceImplementation();
        interImpl2.setImplementedInterface(this.logicalExternalItf2);
        this.lc22.getOwnedInterfaceImplementations().add((Object)interImpl2);
        this.performLCtoPCTransition(Arrays.asList(this.logicalSystem));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalSystem.getName(), (Object)this.logicalSystem.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalSystem) == this.logicalSystem ? 1 : 0) != 0);
        this.psInterfacePkg = this.physicalSystem.getOwnedInterfacePkg();
        this.mustNotBeNull((EObject)this.psInterfacePkg);
        int projectedIntSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedIntSize), (int)projectedIntSize, (int)this.psInterfacePkg.getOwnedInterfaces().size());
        EList outgoing = this.psInterfacePkg.getOutgoingTraces();
        for (AbstractTrace trace : outgoing) {
            tgt = trace.getTargetElement();
            test = tgt != null && tgt == this.logicalInterfacePkg || tgt == this.logicalSystem || tgt == this.lsInterfacePkg;
            LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.psInterfacePkg.getName(), (Object)(String.valueOf(this.logicalInterfacePkg.getName()) + "or" + this.logicalSystem.getName())), (boolean)test);
        }
        projectedIntSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedIntSize), (int)projectedIntSize, (int)this.psInterfacePkg.getOwnedInterfaces().size());
        outgoing = this.psInterfacePkg.getOutgoingTraces();
        for (AbstractTrace trace : outgoing) {
            tgt = trace.getTargetElement();
            test = tgt != null && tgt == this.logicalInterfacePkg || tgt == this.logicalSystem || tgt == this.lsInterfacePkg;
            LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.psInterfacePkg.getName(), (Object)this.lsInterfacePkg.getName()), (boolean)test);
        }
        EList physicalActors = this.physicalActorPkg.getOwnedPhysicalComponents();
        LCPCBreakdownWithItf.assertTrue((String)Messages.ErrorMessage, (physicalActors.size() == 1 ? 1 : 0) != 0);
        int projectedPCSize = 3;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)this.physicalSystem.getOwnedPhysicalComponents().size(), (int)projectedPCSize);
        projectedPCSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)this.pc1.getOwnedPhysicalComponents().size(), (int)projectedPCSize);
        projectedPCSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPCSize), (int)this.pc2.getOwnedPhysicalComponents().size(), (int)projectedPCSize);
        int projectedPFSize = 3;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedPFSize), (int)this.rootPF.getSubFunctions().size(), (int)projectedPFSize);
        int projectedExchangeSize = 2;
        LCPCBreakdownWithItf.assertEquals((String)NLS.bind((String)Messages.WrongSize, (Object)projectedExchangeSize), (int)this.rootPF.getOwnedFunctionalExchanges().size(), (int)projectedExchangeSize);
        LCPCBreakdownWithItf.assertNull((String)NLS.bind((String)Messages.NullError, (Object)this.pf111.getName(), (Object)this.pf111.getName()), (Object)ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf111));
        LCPCBreakdownWithItf.assertNull((String)NLS.bind((String)Messages.NullError, (Object)this.pf111FOP.getName(), (Object)this.pf111FOP.getName()), (Object)ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf111FOP));
        LCPCBreakdownWithItf.assertNull((String)NLS.bind((String)Messages.NullError, (Object)this.pf111Join1Exchange.getName(), (Object)this.pf111Join1Exchange.getName()), (Object)ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.pf111Join1Exchange));
        this.subPC12 = (PhysicalComponent)ProjectionTestUtils.getAllocatingComponent((Component)this.subLC12);
        this.mustNotBeNull((EObject)this.subPC12);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.subPC12.getName(), (Object)this.subLC12.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.subPC12) == this.subLC12 ? 1 : 0) != 0);
        this.physicalExternalItf1 = ProjectionTestUtils.getAllocatingInterface(this.logicalExternalItf1);
        this.mustNotBeNull((EObject)this.physicalExternalItf1);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalExternalItf1.getName(), (Object)this.logicalExternalItf1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalExternalItf1) == this.logicalExternalItf1 ? 1 : 0) != 0);
        this.physicalExternalItf2 = ProjectionTestUtils.getAllocatingInterface(this.logicalExternalItf2);
        this.mustNotBeNull((EObject)this.physicalExternalItf2);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this.physicalExternalItf2.getName(), (Object)this.logicalExternalItf2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.physicalExternalItf2) == this.logicalExternalItf2 ? 1 : 0) != 0);
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc22.getName(), (Object)this.physicalExternalItf1.getName()), (boolean)this.pc22.getImplementedInterfaces().contains((Object)this.physicalExternalItf1));
        LCPCBreakdownWithItf.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this.pc22.getName(), (Object)this.physicalExternalItf2.getName()), (boolean)this.pc22.getImplementedInterfaces().contains((Object)this.physicalExternalItf2));
    }
}

