/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.oa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelOaSa;

public class CapabilityTransition
extends TopDownTransitionTestCase {
    private OperationalCapabilityPkg _rootOCPkg;
    private OperationalCapabilityPkg _subOCPkg;
    private OperationalCapability _oaOC1;
    private OperationalCapability _oaOC11;
    private OperationalCapability _oaOC2;
    private OperationalCapability _oaOC3;
    private OperationalCapability _oaSubOC1;
    private CapabilityPkg _rootCapabilityPkg;
    private CapabilityPkg _subCapabilityPkg;
    private Capability _ctxOC1;
    private Capability _ctxOC11;
    private Capability _ctxOC2;
    private Capability _ctxOC3;
    private Capability _ctxSubOC1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._rootOCPkg = (OperationalCapabilityPkg)this.getObject(ModelOaSa.rootOCPkgId);
        this._oaOC1 = (OperationalCapability)this.getObject(ModelOaSa.oc1Id);
        this._oaOC11 = (OperationalCapability)this.getObject(ModelOaSa.oc11Id);
        this._oaOC2 = (OperationalCapability)this.getObject(ModelOaSa.oc2Id);
        this._rootCapabilityPkg = (CapabilityPkg)this.getObject(ModelOaSa.rootCapabilityPkgId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
    }

    public void performTest1() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._oaOC11));
        this._ctxOC11 = (Capability)this._rootCapabilityPkg.getOwnedCapabilities().get(0);
        this.mustNotBeNull((EObject)this._ctxOC11);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC11.getName(), (Object)this._oaOC11.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC11) == this._oaOC11 ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._rootOCPkg));
        this._ctxOC1 = ProjectionTestUtils.getProjectedCapability(this._oaOC1);
        this.mustNotBeNull((EObject)this._ctxOC1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._oaOC1.getName()), (this._oaOC1.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC1.getName()), (this._ctxOC1.eContainer() == this._rootCapabilityPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC1.getName(), (Object)this._oaOC1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC1) == this._oaOC1 ? 1 : 0) != 0);
        this._ctxOC2 = ProjectionTestUtils.getProjectedCapability(this._oaOC2);
        this.mustNotBeNull((EObject)this._ctxOC2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._oaOC2.getName()), (this._oaOC2.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC2.getName()), (this._ctxOC2.eContainer() == this._rootCapabilityPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC2.getName(), (Object)this._oaOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC2) == this._oaOC2 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._rootOCPkg));
        int oaSize = this._rootOCPkg.getOwnedOperationalCapabilities().size();
        int ctxSize = this._rootCapabilityPkg.getOwnedCapabilities().size();
        CapabilityTransition.assertTrue((String)Messages.WrongAllocation, (oaSize == ctxSize ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.getExecutionManager((EObject)this._rootOCPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                CapabilityTransition.this._oaOC2.destroy();
                CapabilityTransition.this._oaOC3 = OaFactory.eINSTANCE.createOperationalCapability("OC3");
                CapabilityTransition.this._rootOCPkg.getOwnedOperationalCapabilities().add((Object)CapabilityTransition.this._oaOC3);
                CapabilityTransition.this._subOCPkg = OaFactory.eINSTANCE.createOperationalCapabilityPkg("Sub OC Pkg");
                CapabilityTransition.this._rootOCPkg.getOwnedOperationalCapabilityPkgs().add((Object)CapabilityTransition.this._subOCPkg);
                CapabilityTransition.this._oaSubOC1 = OaFactory.eINSTANCE.createOperationalCapability("Sub OC1");
                CapabilityTransition.this._subOCPkg.getOwnedOperationalCapabilities().add((Object)CapabilityTransition.this._oaSubOC1);
            }
        });
        this.performCapabilityTransition(Collections.singletonList(this._rootOCPkg));
        this.mustNotBeNull((EObject)this._ctxOC2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC2.getName(), (Object)this._oaOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC2) == null ? 1 : 0) != 0);
        this._ctxOC3 = ProjectionTestUtils.getProjectedCapability(this._oaOC3);
        this.mustNotBeNull((EObject)this._ctxOC3);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._oaOC3.getName()), (this._oaOC3.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC3.getName()), (this._ctxOC3.eContainer() == this._rootCapabilityPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC3.getName(), (Object)this._oaOC3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC3) == this._oaOC3 ? 1 : 0) != 0);
        this._subCapabilityPkg = (CapabilityPkg)this._rootCapabilityPkg.getOwnedCapabilityPkgs().get(0);
        this.mustNotBeNull((EObject)this._subCapabilityPkg);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._subCapabilityPkg.getName(), (Object)this._subOCPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._subCapabilityPkg) == this._subOCPkg ? 1 : 0) != 0);
        this._ctxSubOC1 = (Capability)this._subCapabilityPkg.getOwnedCapabilities().get(0);
        this.mustNotBeNull((EObject)this._ctxSubOC1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxSubOC1.getName(), (Object)this._oaSubOC1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxSubOC1) == this._oaSubOC1 ? 1 : 0) != 0);
    }
}

