/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.oa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelOaSa;

public class RealizedBySystemTransition
extends TopDownTransitionTestCase {
    private EntityPkg _rootOEPkg;
    private SystemComponent _system;
    private Entity _entity1;
    private Entity _entity2;
    private Entity _entity3;
    private OperationalActivity _OA3;
    private SystemFunction _sf3;
    int _allocation;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this.setPreferenceValue("projection.functional", true);
        this._rootOEPkg = (EntityPkg)this.getObject(ModelOaSa.rootOEPkgId);
        this._entity1 = (Entity)this.getObject(ModelOaSa.entity1Id);
        this._entity2 = (Entity)this.getObject(ModelOaSa.entity2Id);
        this._entity3 = (Entity)this.getObject(ModelOaSa.entity3Id);
        this._OA3 = (OperationalActivity)this.getObject(ModelOaSa.OA3Id);
        this._system = (SystemComponent)this.getObject(ModelOaSa.systemId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performRealizedBySystemTransition(Collections.singletonList(this._entity1));
        RealizedBySystemTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity1.getName()), (boolean)this._system.getRealizedComponents().contains((Object)this._entity1));
        this._allocation = this._system.getOwnedComponentRealizations().size();
    }

    public void performTest2() throws Exception {
        this.performRealizedBySystemTransition(Collections.singletonList(this._entity3));
        this._sf3 = (SystemFunction)ProjectionTestUtils.getAllocatingFunction((AbstractFunction)this._OA3);
        RealizedBySystemTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity3.getName()), (boolean)this._system.getRealizedComponents().contains((Object)this._entity3));
        RealizedBySystemTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this._sf3.getName()), (ProjectionTestUtils.getAllocatedFunction(this._system) == this._sf3 ? 1 : 0) != 0);
        int previousResult = this._allocation;
        this._allocation = this._system.getOwnedComponentRealizations().size();
        RealizedBySystemTransition.assertTrue((String)Messages.WrongAllocation, (this._allocation - previousResult == 1 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performRealizedBySystemTransition(Collections.singletonList(this._entity2));
        RealizedBySystemTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity2.getName()), (boolean)this._system.getRealizedComponents().contains((Object)this._entity2));
        int previousResult = this._allocation;
        this._allocation = this._system.getOwnedComponentRealizations().size();
        RealizedBySystemTransition.assertTrue((String)Messages.WrongAllocation, (this._allocation - previousResult == 1 ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.performRealizedBySystemTransition(Collections.singletonList(this._rootOEPkg));
        int allEntitiesSize = BlockArchitectureExt.getAllComponents((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)this._rootOEPkg)).size();
        int currentSize = this._system.getOwnedComponentRealizations().size();
        RealizedBySystemTransition.assertTrue((String)Messages.WrongAllocation, (currentSize == allEntitiesSize ? 1 : 0) != 0);
        this._allocation = this._system.getOwnedComponentRealizations().size();
    }

    public void performTest5() throws Exception {
        this.performRealizedBySystemTransition(Collections.singletonList(this._entity1));
        int previousResult = this._allocation;
        int currentSize = this._system.getOwnedComponentRealizations().size();
        RealizedBySystemTransition.assertTrue((String)Messages.WrongAllocation, (currentSize == previousResult ? 1 : 0) != 0);
    }
}

