/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.sa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.test.transition.ju.CodeHelper;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelCtxLa;

public class CapabilityTransition
extends TopDownTransitionTestCase {
    private CapabilityPkg _rootcapaPkg;
    private CapabilityPkg _saSubCapaPkg;
    private Capability _saCapa1;
    private Capability _saCapa11;
    private Capability _saCapa2;
    private Capability _saCapa3;
    private Capability _saSubCapa1;
    private CapabilityRealizationPkg _rootCRPkg;
    private CapabilityRealizationPkg _laSubCapaPkg;
    private CapabilityRealization _laCapa1;
    private CapabilityRealization _laCapa11;
    private CapabilityRealization _laCapa2;
    private CapabilityRealization _laCapa3;
    private CapabilityRealization _laSubCapa1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._rootcapaPkg = (CapabilityPkg)this.getObject(ModelCtxLa.rootCapaPkgId);
        this._saCapa1 = (Capability)this.getObject(ModelCtxLa.capa1Id);
        this._saCapa11 = (Capability)this.getObject(ModelCtxLa.capa11Id);
        this._saCapa2 = (Capability)this.getObject(ModelCtxLa.capa2Id);
        this._rootCRPkg = (CapabilityRealizationPkg)this.getObject(ModelCtxLa.rootCRPkgId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
    }

    public void performTest1() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._saCapa11));
        this._laCapa11 = (CapabilityRealization)this._rootCRPkg.getOwnedCapabilityRealizations().get(0);
        this.mustNotBeNull((EObject)this._saCapa11);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laCapa11.getName(), (Object)this._saCapa11.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laCapa11) == this._saCapa11 ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._rootcapaPkg));
        this._laCapa1 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this._rootCRPkg, (EObject)this._saCapa1);
        this.mustNotBeNull((EObject)this._laCapa1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this._saCapa1.getName()), (this._saCapa1.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._laCapa1.getName()), (this._laCapa1.eContainer() == this._rootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laCapa1.getName(), (Object)this._saCapa1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laCapa1) == this._saCapa1 ? 1 : 0) != 0);
        this._laCapa2 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this._rootCRPkg, (EObject)this._saCapa2);
        this.mustNotBeNull((EObject)this._laCapa2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this._saCapa2.getName()), (this._saCapa2.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._laCapa2.getName()), (this._laCapa2.eContainer() == this._rootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laCapa2.getName(), (Object)this._saCapa2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laCapa2) == this._saCapa2 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performCapabilityTransition(Collections.singletonList(this._rootcapaPkg));
        int saSize = this._rootcapaPkg.getOwnedCapabilities().size();
        int laSize = this._rootCRPkg.getOwnedCapabilityRealizations().size();
        CapabilityTransition.assertTrue((String)Messages.WrongSize, (saSize == laSize ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.getExecutionManager((EObject)this._rootcapaPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                CapabilityTransition.this._saCapa2.destroy();
                CapabilityTransition.this._saCapa3 = CtxFactory.eINSTANCE.createCapability("capa3");
                CapabilityTransition.this._rootcapaPkg.getOwnedCapabilities().add((Object)CapabilityTransition.this._saCapa3);
                CapabilityTransition.this._saSubCapaPkg = CtxFactory.eINSTANCE.createCapabilityPkg("SubCapaPkg");
                CapabilityTransition.this._rootcapaPkg.getOwnedCapabilityPkgs().add((Object)CapabilityTransition.this._saSubCapaPkg);
                CapabilityTransition.this._saSubCapa1 = CtxFactory.eINSTANCE.createCapability("SubCapa1");
                CapabilityTransition.this._saSubCapaPkg.getOwnedCapabilities().add((Object)CapabilityTransition.this._saSubCapa1);
            }
        });
        this.performCapabilityTransition(Collections.singletonList(this._rootcapaPkg));
        this.mustNotBeNull((EObject)this._laCapa2);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laCapa2.getName(), (Object)this._saCapa2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laCapa2) == null ? 1 : 0) != 0);
        this._laCapa3 = (CapabilityRealization)CodeHelper.getChildTracingElement((EObject)this._rootCRPkg, (EObject)this._saCapa3);
        this.mustNotBeNull((EObject)this._laCapa3);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this._saCapa3.getName()), (this._saCapa3.getIncomingCapabilityAllocation().size() == 1 ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._laCapa3.getName()), (this._laCapa3.eContainer() == this._rootCRPkg ? 1 : 0) != 0);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laCapa3.getName(), (Object)this._saCapa3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laCapa3) == this._saCapa3 ? 1 : 0) != 0);
        this._laSubCapaPkg = (CapabilityRealizationPkg)this._rootCRPkg.getOwnedCapabilityRealizationPkgs().get(0);
        this.mustNotBeNull((EObject)this._laSubCapaPkg);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubCapaPkg.getName(), (Object)this._saSubCapaPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubCapaPkg) == this._saSubCapaPkg ? 1 : 0) != 0);
        this._laSubCapa1 = (CapabilityRealization)this._laSubCapaPkg.getOwnedCapabilityRealizations().get(0);
        this.mustNotBeNull((EObject)this._laSubCapa1);
        CapabilityTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._laSubCapa1.getName(), (Object)this._saSubCapa1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._laSubCapa1) == this._saSubCapa1 ? 1 : 0) != 0);
    }
}

