/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.re.ReAbstractElement;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.validation.CapellaValidationActivator;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.OracleDefinition;

public abstract class ValidationRuleTestCase
extends BasicTestCase {
    protected String ruleID = this.getRuleID();
    protected EClass targetedEClass = this.getTargetedEClass();
    protected boolean quickFix = this.getCheckQuickFix();
    protected IConstraintDescriptor ruleDescriptor;
    protected IConstraintFilter filter;
    protected IBatchValidator validator;
    protected Hashtable<String, OracleDefinition> objectID2OracleDefinition = new Hashtable();
    private boolean _ruleWasDisabled;

    protected abstract String getRequiredTestModel();

    protected abstract EClass getTargetedEClass();

    protected abstract String getRuleID();

    protected abstract List<OracleDefinition> getOracleDefinitions();

    protected boolean getCheckQuickFix() {
        return false;
    }

    protected IStatus testCheckQuickFix(List<IMarker> markers) {
        return Status.OK_STATUS;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        ConstraintRegistry registry = ConstraintRegistry.getInstance();
        if (this.ruleID != null) {
            this.ruleDescriptor = registry.getDescriptor(this.ruleID);
            if (this.ruleDescriptor == null) {
                throw new InternalError("Rule " + this.ruleID + " does not exist. Test can not be performed");
            }
            if (!this.ruleDescriptor.isEnabled()) {
                this.ruleDescriptor.setEnabled(true);
                this._ruleWasDisabled = true;
            }
            this.filter = new IConstraintFilter(){

                public boolean accept(IConstraintDescriptor constraint_p, EObject target_p) {
                    return ValidationRuleTestCase.this.ruleDescriptor == constraint_p;
                }
            };
            this.validator.addConstraintFilter(this.filter);
        }
    }

    public List<String> getRequiredTestModels() {
        if (this.getRequiredTestModel() != null) {
            return Collections.singletonList(this.getRequiredTestModel());
        }
        return Collections.emptyList();
    }

    protected List<EObject> getTestScope(ICapellaModel model) {
        ArrayList<EObject> scope = new ArrayList<EObject>();
        Project project = model.getProject(this.getSessionForTestModel(this.getRequiredTestModel()).getTransactionalEditingDomain());
        if (project != null) {
            for (EObject object : EObjectExt.getAll((EObject)project, (EClass)this.targetedEClass)) {
                if (!(object instanceof CapellaElement) && !(object instanceof ReAbstractElement)) continue;
                scope.add(object);
            }
        }
        return scope;
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        List<EObject> objectsToValidate = this.getTestScope((ICapellaModel)model);
        List<OracleDefinition> oracleDefinitions = this.getOracleDefinitions();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        if (oracleDefinitions != null) {
            IStatus status;
            for (OracleDefinition definition : oracleDefinitions) {
                this.objectID2OracleDefinition.put(definition.getObjectID(), definition);
            }
            ArrayList<EObject> failedObjects = new ArrayList<EObject>();
            Diagnostician diagnostician = new Diagnostician();
            for (EObject object : objectsToValidate) {
                String objectID = this.getId(object);
                OracleDefinition oracleDef = this.objectID2OracleDefinition.get(objectID);
                Diagnostic diagnostic = diagnostician.validate(object);
                if (diagnostic.getSeverity() == 0 && oracleDef != null && oracleDef.getNbExpectedErrors() > 0) {
                    ValidationRuleTestCase.fail((String)("Validation rule " + this.ruleID + " has not detected an error on object " + objectID + " while it must be the case"));
                    continue;
                }
                if (diagnostic.getSeverity() == 0) continue;
                for (Diagnostic diag : diagnostic.getChildren()) {
                    IMarker marker = LightMarkerRegistry.getInstance().createMarker((IResource)EcoreUtil2.getFile((Resource)object.eResource()), diag, "org.polarsys.capella.core.validation.markers");
                    if (marker == null) continue;
                    markers.add(marker);
                }
                this.assertExpectedRuleHasBeenThrown(diagnostic, object);
                if (oracleDef != null) {
                    oracleDef.countOneError();
                    continue;
                }
                failedObjects.add(object);
            }
            if (!failedObjects.isEmpty()) {
                String objects = failedObjects.stream().map(elt -> " - " + this.getId((EObject)elt)).collect(Collectors.joining("\n"));
                ValidationRuleTestCase.fail((String)NLS.bind((String)"Validation rule {0} has detected an error on object(s): \n{1}\nwhile it must not be the case.", (Object)this.ruleID, (Object)objects));
            }
            for (OracleDefinition oracleDef : oracleDefinitions) {
                int nbExpectedErrors = oracleDef.getNbExpectedErrors();
                int nbFoundErrors = oracleDef.getNbFoundErrors();
                if (nbFoundErrors < nbExpectedErrors) {
                    ValidationRuleTestCase.fail((String)("Validation rule " + this.ruleID + " has only detected " + nbFoundErrors + " of " + nbExpectedErrors + " expected error(s) on object " + oracleDef.getObjectID()));
                    continue;
                }
                if (nbFoundErrors <= nbExpectedErrors) continue;
                ValidationRuleTestCase.fail((String)("Validation rule " + this.ruleID + " has detected " + nbFoundErrors + " error(s) instead of " + nbExpectedErrors + " error(s) on object " + oracleDef.getObjectID()));
            }
            if (this.getCheckQuickFix() && (status = this.testCheckQuickFix(markers)) != null && !status.isOK()) {
                ValidationRuleTestCase.fail((String)status.getMessage());
            }
        }
    }

    protected void assertExpectedRuleHasBeenThrown(Diagnostic diagnostic, EObject object) {
        ValidationRuleTestCase.assertFalse((boolean)diagnostic.getChildren().isEmpty());
        Diagnostic nestedDiag = (Diagnostic)diagnostic.getChildren().get(0);
        ValidationRuleTestCase.assertTrue((String)("Validation rule " + this.ruleID + " has detected another kind of error, please check EMF integrity of the model: " + this.getAirdURI(object)), (boolean)(nestedDiag instanceof ConstraintStatusDiagnostic));
        String ruleIdThrown = ((ConstraintStatusDiagnostic)nestedDiag).getConstraintStatus().getConstraint().getDescriptor().getId();
        ValidationRuleTestCase.assertEquals((String)("Validation rule " + ruleIdThrown + " has detected an error but " + this.ruleID + " expected"), (String)ruleIdThrown, (String)this.ruleID);
    }

    protected String getAirdURI(EObject object) {
        return SessionManager.INSTANCE.getSession(object).getSessionResource().getURI().toPlatformString(true);
    }

    protected String getId(EObject object) {
        if (object instanceof CapellaElement) {
            return ((CapellaElement)object).getId();
        }
        if (object instanceof ReAbstractElement) {
            return ((ReAbstractElement)object).getId();
        }
        throw new IllegalArgumentException(String.valueOf(object.eClass().getName()) + "is not supported as a validation targeted EClass");
    }

    protected void tearDown() throws Exception {
        if (this._ruleWasDisabled && this.ruleDescriptor != null) {
            this.ruleDescriptor.setEnabled(false);
        }
        if (this.validator != null) {
            this.validator.removeConstraintFilter(this.filter);
        }
        super.tearDown();
    }
}

