/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.IViewPart;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.LibrariesFactory;
import org.polarsys.capella.common.libraries.LibraryReference;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.core.validation.constraint.ReferentialConstraintsResourceSetListener;
import org.polarsys.capella.core.libraries.model.CapellaLibraryExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class Rule_I37_38
extends BasicTestCase {
    ExecutionManager manager;
    CapellaModelSkeleton projectSkeleton;
    CapellaModelSkeleton librarySkeleton;
    IViewPart moveView;

    public void setUp() throws Exception {
        super.setUp();
        this.manager = ExecutionManagerRegistry.getInstance().addNewManager();
        this.projectSkeleton = new CapellaModelSkeleton.Builder(this.manager).setURI(URI.createPlatformResourceURI((String)"/project/project.melodymodeller", (boolean)false)).setName("project").build();
        this.librarySkeleton = new CapellaModelSkeleton.Builder(this.manager).setURI(URI.createPlatformResourceURI((String)"/library/library.melodymodeller", (boolean)false)).setName("library").setRootType(CapellamodellerPackage.Literals.LIBRARY).build();
        final ModelInformation projectInformation = CapellaLibraryExt.getModelInformation((Resource)this.projectSkeleton.getProject().eResource(), (boolean)false);
        final ModelInformation libraryInformation = CapellaLibraryExt.getModelInformation((Resource)this.librarySkeleton.getProject().eResource(), (boolean)false);
        this.manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                LibraryReference ref = LibrariesFactory.eINSTANCE.createLibraryReference();
                ref.setLibrary(libraryInformation);
                ref.setAccessPolicy(AccessPolicy.READ_AND_WRITE);
                projectInformation.getOwnedReferences().add((Object)ref);
            }
        });
    }

    public void tearDown() throws Exception {
        ExecutionManagerRegistry.getInstance().removeManager(this.manager);
        super.tearDown();
    }

    protected void executeCommand(final Runnable r) throws InterruptedException, RollbackException {
        RecordingCommand rc = new RecordingCommand(this.manager.getEditingDomain()){

            protected void doExecute() {
                r.run();
            }
        };
        TransactionalCommandStack stack = (TransactionalCommandStack)this.manager.getEditingDomain().getCommandStack();
        stack.execute((Command)rc, Collections.emptyMap());
    }

    protected void expectNoRollback(Runnable r) throws InterruptedException, RollbackException {
        ReferentialConstraintsRecorder recorder = new ReferentialConstraintsRecorder(this.manager.getEditingDomain(), new String[0]);
        try {
            this.executeCommand(r);
        }
        finally {
            recorder.dispose();
        }
    }

    protected void expectRollback(Runnable r, String ... expectedErrors) throws InterruptedException {
        ReferentialConstraintsRecorder recorder;
        block6: {
            recorder = new ReferentialConstraintsRecorder(this.manager.getEditingDomain(), expectedErrors);
            try {
                try {
                    this.executeCommand(r);
                }
                catch (RollbackException rollbackException) {
                    recorder.dispose();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                recorder.dispose();
                throw throwable;
            }
            recorder.dispose();
        }
        if (recorder.missingExpected.size() > 0) {
            Rule_I37_38.fail((String)String.join((CharSequence)System.lineSeparator(), recorder.missingExpected));
        }
    }

    private static class ReferentialConstraintsRecorder {
        private Collection<String> missingExpected;
        private final TransactionalEditingDomain domain;
        private final ReferentialConstraintsResourceSetListener listener;

        public ReferentialConstraintsRecorder(TransactionalEditingDomain domain, String ... expectedErrors) {
            this.missingExpected = new ArrayList<String>(Arrays.asList(expectedErrors));
            this.domain = domain;
            this.listener = new ReferentialConstraintsResourceSetListener(this::handleDiagnostic);
            domain.addResourceSetListener((ResourceSetListener)this.listener);
        }

        public void handleDiagnostic(Diagnostic ms) throws RollbackException {
            Iterator<String> it = this.missingExpected.iterator();
            while (it.hasNext()) {
                String expected = it.next();
                if (this.findDiagnostic(expected, ms.getChildren()) == null) continue;
                it.remove();
            }
            throw new RollbackException((IStatus)new Status(4, "org.polarsys.capella.test.validation.rules.ju", "rolling back"));
        }

        private Diagnostic findDiagnostic(String message, Collection<Diagnostic> diagnostics) {
            for (Diagnostic d : diagnostics) {
                if (!message.equals(d.getMessage())) continue;
                return d;
            }
            return null;
        }

        private void dispose() {
            this.domain.removeResourceSetListener((ResourceSetListener)this.listener);
        }
    }
}

