/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.commandline.ju.testcases;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.capella.core.validation.commandline.Messages;
import org.polarsys.capella.core.validation.commandline.ValidationCommandLine;
import org.polarsys.capella.test.commandline.ju.utils.MockApplicationContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;

public class CommandLineValidationTest
extends BasicTestCase {
    public void test() throws Exception {
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
        String projectName = "Test Command Line Validation";
        File sourceFolder = this.getFolderInTestModelRepository(projectName);
        ModelProviderHelper.getInstance().importCapellaProject(projectName, sourceFolder);
        String[] validationCommandLineArguments = new String[]{"-appid", "org.polarsys.capella.core.validation.commandline", "-input", String.valueOf(projectName) + "/Test Command Line Validation.aird", "-outputfolder", String.valueOf(projectName) + "/ValidationResult", "-forceoutputfoldercreation"};
        MockApplicationContext mockApplicationContext = new MockApplicationContext(validationCommandLineArguments);
        ValidationCommandLine validationCommandLine = new ValidationCommandLine();
        validationCommandLine.parseContext((IApplicationContext)mockApplicationContext);
        validationCommandLine.checkArgs((IApplicationContext)mockApplicationContext);
        validationCommandLine.prepare((IApplicationContext)mockApplicationContext);
        validationCommandLine.execute((IApplicationContext)mockApplicationContext);
        IPath validationResultFile = workspaceLocation.append(projectName).append("ValidationResult").append(projectName).append(String.valueOf(projectName) + ".aird").append(Messages.resultsFileName);
        byte[] fileContentInBytes = Files.readAllBytes(Paths.get(validationResultFile.toOSString(), new String[0]));
        String fileContentInString = new String(fileContentInBytes);
        CommandLineValidationTest.assertTrue((fileContentInString.contains("DCOM_03") && fileContentInString.contains("TJ_SA_01") ? 1 : 0) != 0);
        CommandLineValidationTest.assertTrue((boolean)fileContentInString.contains("/Test Command Line Validation/TestCommandLineValidation/Operational Analysis/Operational Activities/Root Operational Activity/OperationalActivity 1"));
    }
}

