/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.xab.ReuseComponentTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class PABDiagram
extends XABDiagram {
    public PABDiagram(SessionContext context, DDiagram diagram) {
        super(BlockArchitectureExt.Type.PA, context, diagram);
    }

    public static PABDiagram openDiagram(SessionContext executionContext, String name) {
        return (PABDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new PABDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static PABDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return (PABDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, "Physical Architecture Blank"){

            @Override
            public DiagramContext getResult() {
                return new PABDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createNodeComponent(String id, String containerId) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, "node.pc", containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void cannotCreateNodeComponent(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, "node.pc", containerId, id).cannotRun();
    }

    public void cannotReuseNodeComponent(String containerId, String id) {
        new ReuseComponentTool(this, "reuse.node.pc", containerId){

            @Override
            protected void postRunTest() {
                for (EObject component : this.getDiagramContext().getSessionContext().getSemanticElements(this.selectedElements)) {
                    if (!(component instanceof Component)) continue;
                    EList parts = ((Component)component).getRepresentingParts();
                    this.getDiagramContext().hasView(((Part)parts.get(parts.size() - 1)).getId());
                    Assert.assertTrue((String)("A new part referencing " + ((Component)component).getId() + " shouldn't have been created"), (parts.size() == ((List)this.representingParts.get(component)).size() ? 1 : 0) != 0);
                }
            }
        }.select(id);
    }

    public String createBehaviorComponent(String id, String containerId) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, "behavior.pc", containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void cannotCreateBehaviorComponent(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, "behavior.pc", containerId, id).cannotRun();
    }

    public void cannotReuseBehaviourComponent(String containerId, String id) {
        new ReuseComponentTool(this, "reuse.behaviour.pc", containerId){

            @Override
            protected void postRunTest() {
                for (EObject component : this.getDiagramContext().getSessionContext().getSemanticElements(this.selectedElements)) {
                    if (!(component instanceof Component)) continue;
                    EList parts = ((Component)component).getRepresentingParts();
                    this.getDiagramContext().hasView(((Part)parts.get(parts.size() - 1)).getId());
                    Assert.assertTrue((String)("A new part referencing " + ((Component)component).getId() + " shouldn't have been created"), (parts.size() == ((List)this.representingParts.get(component)).size() ? 1 : 0) != 0);
                }
            }
        }.select(id);
    }

    public void failedCreateBehaviorComponent(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, "behavior.pc", containerId, id).shouldFail();
    }

    public String createDeployedBehaviorComponent(String id, String containerId) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, "deploy.behavior.pc", containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void cannotCreateDeployedBehaviorComponent(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, "deploy.behavior.pc", containerId, id).cannotRun();
    }

    public String createDeployedNodeComponent(String id, String containerId) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, "deploy.node.pc", containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void cannotCreateDeployedNodeComponent(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, "deploy.node.pc", containerId, id).cannotRun();
    }

    public void removeDeployedBehaviorComponent(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "deployed.behaviour.pcs", containerId).remove(id);
    }

    public void insertDeployedBehaviorComponent(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "deployed.behaviour.pcs", containerId).insert(id);
    }

    public void removeDeployedNodeComponent(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "deployed.node.pcs", containerId).remove(id);
    }

    public void insertDeployedNodeComponent(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "deployed.node.pcs", containerId).insert(id);
    }

    public void removeNodeComponent(String id, String containerId) {
        String toolName = "node.pcs.monopart";
        if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget()))) {
            toolName = "node.pcs.multipart";
        }
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).remove(id);
    }

    public void insertNodeComponent(String id, String containerId) {
        String toolName = "node.pcs.monopart";
        if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget()))) {
            toolName = "node.pcs.multipart";
        }
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).insert(id);
    }

    public void reuseNodeComponent(String containerId, String ... ids) {
        new ReuseComponentTool(this, "reuse.node.pc", containerId).select(ids);
    }

    public void reuseBehaviourComponent(String containerId, String ... ids) {
        new ReuseComponentTool(this, "reuse.behaviour.pc", containerId).select(ids);
    }

    public void removeBehaviorComponent(String id, String containerId) {
        String toolName = "behavior.pcs.monopart";
        if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget()))) {
            toolName = "behavior.pcs.multipart";
        }
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).remove(id);
    }

    public void insertBehaviorComponent(String id, String containerId) {
        String toolName = "behavior.pcs.monopart";
        if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget()))) {
            toolName = "behavior.pcs.multipart";
        }
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).insert(id);
    }

    public void createComponentPortAllocation(String sourceId, String targetId) {
        new CreateDEdgeTool(this, "component.port.allocation", sourceId, targetId).run();
    }

    public void removeComponentPortAllocation(String containerId) {
        new InsertRemoveTool((DiagramContext)this, "component.port.allocations", containerId).remove(new String[0]);
    }

    public void insertComponentPortAllocation(String containerId) {
        new InsertRemoveTool((DiagramContext)this, "component.port.allocations", containerId).insert(new String[0]);
    }

    public void manageManageNodePCsDeployment(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "manage.node.pcs.deployment", containerId).insert(id);
    }

    public void manageBehaviorPCsDeployment(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "manage.behavior.pcs.deployment", containerId).insert(id);
    }

    public void dragAndDropDeployment(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DnD AB Deployment");
    }
}

