/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.ControlNodeKind;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SequenceLinkEndExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeWithSelectionTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XFCDDiagram
extends CommonDiagram {
    public XFCDDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static XFCDDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        switch (type) {
            case OA: {
                name = "Operational Process Description";
                break;
            }
            default: {
                name = "Functional Chain Description";
            }
        }
        return (XFCDDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XFCDDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static XFCDDiagram getDiagram(SessionContext executionContext, String targetIdentifier) {
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((ResourceSet)executionContext.getSession().getTransactionalEditingDomain().getResourceSet(), (String)targetIdentifier);
        return new XFCDDiagram(executionContext, (DDiagram)descriptor.getRepresentation());
    }

    public String getTargetId(DDiagramElement element) {
        return ((FunctionalChainInvolvement)element.getTarget()).getId();
    }

    public String involveFunction(String containerId, String selectedFunction) {
        InsertInvolvementTool insertInvolvementTool = new InsertInvolvementTool(this, "involve.function", containerId);
        insertInvolvementTool.insert(selectedFunction);
        DDiagramElement result = insertInvolvementTool.getResult();
        return this.getTargetId(result);
    }

    public String involveFunctionalChain(String containerId, String selectedFunctionalChainId) {
        InsertInvolvementTool insertInvolvementTool = new InsertInvolvementTool(this, "involve.functional.chain", containerId);
        insertInvolvementTool.insert(selectedFunctionalChainId);
        DDiagramElement result = insertInvolvementTool.getResult();
        return this.getTargetId(result);
    }

    public void involveExchangeAndFunction(String functionInvolvementId, String functionalExchangeId) {
        new InsertInvolvementTool(this, "involve.exchange.and.function", functionInvolvementId).insert(functionalExchangeId);
    }

    public String connectFunctions(String functionInvolvementSourceId, String functionInvolvementTargetId) {
        DDiagramElement result = (DDiagramElement)new ConnectFunctionsTool(this, "connect.functions", functionInvolvementSourceId, functionInvolvementTargetId).run();
        return this.getTargetId(result);
    }

    public String involveExchange(String sourceViewId, String targetViewId, String functionalExchangeId) {
        DDiagramElement result = (DDiagramElement)new ExchangeTool(this, "involve.exchange", sourceViewId, targetViewId, functionalExchangeId).run();
        return this.getTargetId(result);
    }

    public String createControlNode(String containerId, ControlNodeKind kind) {
        String toolName = this.getControlNodeToolName(kind);
        DNode graphicalElement = (DNode)new CreateControlNodeTool(this, toolName, containerId, kind).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createControlNode(String targetId, String containerId, ControlNodeKind kind) {
        String toolName = this.getControlNodeToolName(kind);
        DNode graphicalElement = (DNode)new CreateControlNodeTool(this, toolName, targetId, containerId, kind).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createConstructControlNode(String containerId, ControlNodeKind kind) {
        String toolName = this.getConstructControlNodeToolName(kind);
        DNode graphicalElement = (DNode)new CreateConstructControlNodeTool(this, toolName, containerId, kind).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createConstructControlNode(String targetId, String containerId, ControlNodeKind kind) {
        String toolName = this.getConstructControlNodeToolName(kind);
        DNode graphicalElement = (DNode)new CreateConstructControlNodeTool(this, toolName, targetId, containerId, kind).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createSequenceLink(String source, String target) {
        String toolName = "sequence.link";
        DEdge graphicalElement = (DEdge)new CreateSequenceLinkTool(this, toolName, source, target).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public void cannotCreateSequenceLink(String source, String target) {
        String toolName = "sequence.link";
        new CreateSequenceLinkTool(this, toolName, source, target).cannotRun();
    }

    public String createFunctionOnSequenceLink(String functionId, String targetId) {
        String toolName = "involve.function.on.sequence.link";
        DNode graphicalElement = (DNode)new CreateFunctionOnSequenceLinkTool(this, toolName, functionId, targetId, this.getDiagramId()).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createExchangeWithSequenceLink(String sourceId, String targetId, String functionalExchangeId) {
        String toolName = "involve.exchange.with.sequence.link";
        DEdge graphicalElement = (DEdge)new CreateExchangeWithSequenceLinkTool(this, toolName, sourceId, targetId, functionalExchangeId).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public void cannotCreateExchangeWithSequenceLink(String sourceId, String targetId) {
        String toolName = "involve.exchange.with.sequence.link";
        new CreateExchangeWithSequenceLinkTool(this, toolName, sourceId, targetId, null).cannotRun();
    }

    public void invalidCreateExchangeWithSequenceLink(String sourceId, String targetId) {
        String toolName = "involve.exchange.with.sequence.link";
        new CreateExchangeWithSequenceLinkTool(this, toolName, sourceId, targetId, null).shouldFail();
    }

    public String associateSequenceLinkWithExchange(String sourceId, String targetId, String sequenceLinkId) {
        String toolName = "associate.sequence.link.with.exchange";
        DEdge graphicalElement = (DEdge)new AssociateSequenceLinkToExchangeTool(this, toolName, sourceId, targetId, sequenceLinkId).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public void cannotAssociateSequenceLinkWithExchange(String sourceId, String targetId) {
        String toolName = "associate.sequence.link.with.exchange";
        new AssociateSequenceLinkToExchangeTool(this, toolName, sourceId, targetId, null).cannotRun();
    }

    private String getControlNodeToolName(ControlNodeKind kind) {
        String name = "";
        switch (kind) {
            case AND: {
                name = "and";
                break;
            }
            case OR: {
                name = "or";
                break;
            }
            case ITERATE: {
                name = "it";
                break;
            }
        }
        return name;
    }

    private String getConstructControlNodeToolName(ControlNodeKind kind) {
        String name = "";
        switch (kind) {
            case AND: {
                name = "and.construct";
                break;
            }
            case OR: {
                name = "or.construct";
                break;
            }
            case ITERATE: {
                name = "it.construct";
                break;
            }
        }
        return name;
    }

    public String accelerateOnFunctionalChainInvolvementLink(String fcilID) {
        DEdge sequenceLink = (DEdge)new AccelerateSequenceLinkFromInvolvementLink(this, "sequence.link.from.exchange", fcilID).run();
        return this.getSemanticIdFromView((DDiagramElement)sequenceLink);
    }

    public String accelerateOnSequenceLinkWithSelect(String selectedSeqLink, String targetFCILinkID) {
        DEdge fciLink = (DEdge)new AccelerateInvolvementLinkFromSequenceLink(this, "involve.exchange.from.sequence.link", targetFCILinkID, selectedSeqLink).run();
        return this.getSemanticIdFromView((DDiagramElement)fciLink);
    }

    public String accelerateOnSequenceLinkWithCreate(String selectedSeqLink, String feSource, String feTarget) {
        DEdge fciLink = (DEdge)new AccelerateInvolvementLinkFromSequenceLink(this, "involve.exchange.from.sequence.link", selectedSeqLink, feSource, feTarget).run();
        return this.getSemanticIdFromView((DDiagramElement)fciLink);
    }

    protected class AccelerateInvolvementLinkFromSequenceLink
    extends AbstractToolStep<DEdge> {
        protected String targetFunctionalExchange;
        protected String selectedSequenceLink;
        protected String createdFunctionalChainInvolvementLink;
        protected int initialNumberOfSequenceLinks;
        protected int initialNumberOfFunctionalChainInvolvementLinks;
        protected int initialNumberOfAssociatedFCILForSelectedSeqLink;
        protected boolean isTargetFEOnDiagram;
        protected boolean isTargetFESelectedInDialog;
        protected String feSource;
        protected String feTarget;

        public AccelerateInvolvementLinkFromSequenceLink(DiagramContext diagramContext, String toolName, String targetFunctionalExchange, String selectedSequenceLink) {
            super(diagramContext, toolName);
            this.isTargetFEOnDiagram = false;
            this.targetFunctionalExchange = targetFunctionalExchange;
            this.selectedSequenceLink = selectedSequenceLink;
            this.isTargetFESelectedInDialog = true;
        }

        public AccelerateInvolvementLinkFromSequenceLink(DiagramContext diagramContext, String toolName, String selectedSequenceLink, String feSource, String feTarget) {
            super(diagramContext, toolName);
            this.isTargetFEOnDiagram = false;
            this.selectedSequenceLink = selectedSequenceLink;
            this.feSource = feSource;
            this.feTarget = feTarget;
            this.isTargetFESelectedInDialog = false;
        }

        private IHeadlessResult createOperation() {
            return new IHeadlessResult(){

                @Override
                public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                    Object result = AccelerateInvolvementLinkFromSequenceLink.this.isTargetFESelectedInDialog ? XFCDDiagram.this.getSessionContext().getSemanticElement(AccelerateInvolvementLinkFromSequenceLink.this.targetFunctionalExchange) : Arrays.asList(XFCDDiagram.this.getSessionContext().getSemanticElement(AccelerateInvolvementLinkFromSequenceLink.this.feSource), XFCDDiagram.this.getSessionContext().getSemanticElement(AccelerateInvolvementLinkFromSequenceLink.this.feTarget));
                    return result;
                }
            };
        }

        @Override
        protected void preRunTest() {
            if (this.getDiagramContext().getView(this.selectedSequenceLink) == null) {
                Assert.fail((String)"The selected SequenceLink is not present on the diagram");
            }
            if (this.isTargetFESelectedInDialog) {
                FunctionalExchange targetExchange = (FunctionalExchange)XFCDDiagram.this.getSessionContext().getSemanticElement(this.targetFunctionalExchange);
                for (DEdge edge : XFCDDiagram.this.getDiagram().getEdges()) {
                    if (!(edge.getTarget() instanceof FunctionalChainInvolvementLink) || !((FunctionalChainInvolvementLink)edge.getTarget()).getInvolved().equals(targetExchange)) continue;
                    this.isTargetFEOnDiagram = true;
                    break;
                }
            } else {
                this.initialNumberOfAssociatedFCILForSelectedSeqLink = ((SequenceLink)XFCDDiagram.this.getSessionContext().getSemanticElement(this.selectedSequenceLink)).getLinks().size();
            }
            this.initialNumberOfSequenceLinks = XFCDDiagram.this.getDiagram().getEdges().stream().map(DSemanticDecorator::getTarget).filter(SequenceLink.class::isInstance).collect(Collectors.toList()).size();
            this.initialNumberOfFunctionalChainInvolvementLinks = XFCDDiagram.this.getDiagram().getEdges().stream().map(DSemanticDecorator::getTarget).filter(FunctionalChainInvolvementLink.class::isInstance).collect(Collectors.toList()).size();
            HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
            super.preRunTest();
        }

        protected void postRunTest() {
            int currentNumberOfAssociatedLinks;
            DiagramHelper.refreshDiagram(XFCDDiagram.this.getDiagram());
            SequenceLink semanticSelectedLink = (SequenceLink)XFCDDiagram.this.getSessionContext().getSemanticElement(this.selectedSequenceLink);
            List sequenceLinksAfterTest = XFCDDiagram.this.getDiagram().getEdges().stream().map(DSemanticDecorator::getTarget).filter(SequenceLink.class::isInstance).collect(Collectors.toList());
            int numberOfSequenceLinksAfterTest = sequenceLinksAfterTest.size();
            int numberOfNewSequenceLinks = numberOfSequenceLinksAfterTest - this.initialNumberOfSequenceLinks;
            if (numberOfNewSequenceLinks != 1) {
                Assert.fail((String)("The number of new sequence links " + numberOfNewSequenceLinks + " is not equal to 1!"));
            }
            if (!this.isTargetFEOnDiagram) {
                List FunctionalChainInvolvementLinksAfterTest = XFCDDiagram.this.getDiagram().getEdges().stream().map(DSemanticDecorator::getTarget).filter(FunctionalChainInvolvementLink.class::isInstance).collect(Collectors.toList());
                int numberOfFCILinksAfterTest = FunctionalChainInvolvementLinksAfterTest.size();
                if (numberOfFCILinksAfterTest - this.initialNumberOfFunctionalChainInvolvementLinks != 1) {
                    Assert.fail((String)("The number of new FCI links " + numberOfFCILinksAfterTest + " is not equal to 1!"));
                }
            }
            EList associatedFCILinks = semanticSelectedLink.getLinks();
            if (this.isTargetFESelectedInDialog && !((FunctionalChainInvolvementLink)associatedFCILinks.get(associatedFCILinks.size() - 1)).getInvolved().getId().equals(this.targetFunctionalExchange)) {
                Assert.fail((String)"The selected SequenceLink is not associated with the selected FunctionalChainInvolvementLink!");
            } else if (!this.isTargetFEOnDiagram && (currentNumberOfAssociatedLinks = associatedFCILinks.size()) - this.initialNumberOfAssociatedFCILForSelectedSeqLink != 1) {
                Assert.fail((String)"No new FunctionalChainInvolvementLinks have been associated with the selected SequenceLink");
            }
            this.createdFunctionalChainInvolvementLink = ((FunctionalChainInvolvementLink)associatedFCILinks.get(associatedFCILinks.size() - 1)).getId();
        }

        @Override
        protected void initToolArguments() {
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, XFCDDiagram.this.getSessionContext().getSemanticElement(this.selectedSequenceLink));
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, this.getDiagramContext().getView(this.selectedSequenceLink));
        }

        public DEdge getResult() {
            return (DEdge)this.getDiagramContext().getView(this.createdFunctionalChainInvolvementLink);
        }
    }

    protected class AccelerateSequenceLinkFromInvolvementLink
    extends AbstractToolStep<DEdge> {
        protected String selectedFunctionalChainInvolvementLink;
        protected int initialNumberOfSequenceLinks;
        protected SequenceLink createdSequenceLink;

        public AccelerateSequenceLinkFromInvolvementLink(DiagramContext diagramContext, String toolName, String selectedFunctionalChainInvolvementLink) {
            super(diagramContext, toolName);
            this.selectedFunctionalChainInvolvementLink = selectedFunctionalChainInvolvementLink;
        }

        @Override
        protected void initToolArguments() {
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, XFCDDiagram.this.getSessionContext().getSemanticElement(this.selectedFunctionalChainInvolvementLink));
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, this.getDiagramContext().getView(this.selectedFunctionalChainInvolvementLink));
        }

        @Override
        protected void preRunTest() {
            if (this.getDiagramContext().getView(this.selectedFunctionalChainInvolvementLink) == null) {
                Assert.fail((String)"The selected FunctionalChainInvolvementLink is not present on the diagram");
            }
            this.initialNumberOfSequenceLinks = XFCDDiagram.this.getDiagram().getEdges().stream().map(DSemanticDecorator::getTarget).filter(SequenceLink.class::isInstance).collect(Collectors.toList()).size();
            super.preRunTest();
        }

        protected void postRunTest() {
            DiagramHelper.refreshDiagram(XFCDDiagram.this.getDiagram());
            FunctionalChainInvolvementLink semanticSelectedLink = (FunctionalChainInvolvementLink)XFCDDiagram.this.getSessionContext().getSemanticElement(this.selectedFunctionalChainInvolvementLink);
            List sequenceLinksAfterTest = XFCDDiagram.this.getDiagram().getEdges().stream().map(DSemanticDecorator::getTarget).filter(SequenceLink.class::isInstance).collect(Collectors.toList());
            int numberOfSequenceLinksAfterTest = sequenceLinksAfterTest.size();
            if (numberOfSequenceLinksAfterTest - this.initialNumberOfSequenceLinks != 2) {
                Assert.fail((String)("The number of new sequence links " + numberOfSequenceLinksAfterTest + " is not equal to 2!"));
            }
            int lastIndexOfTheSequencLinkList = numberOfSequenceLinksAfterTest - 1;
            this.createdSequenceLink = (SequenceLink)sequenceLinksAfterTest.get(lastIndexOfTheSequencLinkList);
            if (!this.createdSequenceLink.getLinks().contains((Object)semanticSelectedLink)) {
                Assert.fail((String)"The new SequenceLink is not associated with the selected FunctionalChainInvolvementLink!");
            }
        }

        public DEdge getResult() {
            return (DEdge)this.getDiagramContext().getView((EObject)this.createdSequenceLink);
        }
    }

    protected class AssociateSequenceLinkToExchangeTool
    extends CreateDEdgeTool {
        protected String sequenceLinkId;

        public AssociateSequenceLinkToExchangeTool(DiagramContext context, String toolName, String sourceViewId, String targetViewId, String sequenceLinkId) {
            super(context, toolName, sourceViewId, targetViewId);
            this.sequenceLinkId = sequenceLinkId;
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            Set newLinks = this._newEdgesElements.stream().filter(x -> {
                if (x.getTarget() instanceof SequenceLink) {
                    SequenceLink link = (SequenceLink)x.getTarget();
                    return link.getId().equals(this.sequenceLinkId);
                }
                return false;
            }).collect(Collectors.toSet());
            Assert.assertTrue((String)"A new edge is expected to be created", (!newLinks.isEmpty() ? 1 : 0) != 0);
            SequenceLink sequenceLink = (SequenceLink)XFCDDiagram.this.getSessionContext().getSemanticElement(this.sequenceLinkId);
            EList associatedLinks = sequenceLink.getLinks();
            Assert.assertTrue((String)"SequenceLink does not have associated links", (!associatedLinks.isEmpty() ? 1 : 0) != 0);
        }
    }

    protected class ConnectFunctionsTool
    extends CreateDEdgeTool {
        public ConnectFunctionsTool(DiagramContext context, String toolName, String sourceView, String targetView) {
            super(context, toolName, sourceView, targetView);
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            DEdge edge = this.getResult();
            DNode sourceNode = (DNode)edge.getSourceNode();
            EObject sourceNodeTarget = sourceNode.getTarget();
            Assert.assertTrue((boolean)(sourceNodeTarget instanceof FunctionalChainInvolvementFunction));
            FunctionalChainInvolvementFunction sourceInvolvementFunction = (FunctionalChainInvolvementFunction)sourceNodeTarget;
            EObject resultTarget = edge.getTarget();
            Assert.assertTrue((boolean)(resultTarget instanceof FunctionalChainInvolvementLink));
            FunctionalChainInvolvementLink involvementLink = (FunctionalChainInvolvementLink)resultTarget;
            Assert.assertEquals((Object)sourceInvolvementFunction.getInvolved(), (Object)involvementLink.getInvolved());
        }
    }

    protected static enum ControlNodeContainer {
        DIAGRAM,
        SEQUENCE_LINK;

    }

    protected class CreateConstructControlNodeTool
    extends CreateControlNodeTool {
        public CreateConstructControlNodeTool(DiagramContext context, String toolName, String containerView, ControlNodeKind kind) {
            super(context, toolName, containerView, kind);
        }

        public CreateConstructControlNodeTool(DiagramContext context, String toolName, String targetView, String containerView, ControlNodeKind kind) {
            super(context, toolName, targetView, containerView, kind);
        }

        @Override
        protected void postRunTest() {
            this.newElements = this.getDiagramElements(this.getContainerView());
            this.newElements.removeAll(this.elements);
            Set nodes = this.newElements.stream().filter(x -> x.getTarget() instanceof ControlNode).collect(Collectors.toSet());
            Assert.assertTrue((String)"Two new ControlNode are expected to be created", (nodes.size() == 2 ? 1 : 0) != 0);
            Iterator it = nodes.iterator();
            ControlNode controlNode1 = (ControlNode)((DDiagramElement)it.next()).getTarget();
            ControlNode controlNode2 = (ControlNode)((DDiagramElement)it.next()).getTarget();
            Assert.assertTrue((String)("ControlNode should be of kind " + this.kind), (controlNode1.getKind() == this.kind ? 1 : 0) != 0);
            Assert.assertTrue((String)("ControlNode should be of kind " + this.kind), (controlNode2.getKind() == this.kind ? 1 : 0) != 0);
            List listcn1In = SequenceLinkEndExt.getIncomingSequenceLinks((SequenceLinkEnd)controlNode1);
            List listcn1Out = SequenceLinkEndExt.getOutgoingSequenceLinks((SequenceLinkEnd)controlNode1);
            List listcn2In = SequenceLinkEndExt.getIncomingSequenceLinks((SequenceLinkEnd)controlNode2);
            List listcn2Out = SequenceLinkEndExt.getOutgoingSequenceLinks((SequenceLinkEnd)controlNode2);
            String messagePattern = "Invalid ControlNode {4} contruct created, inserted ControlNode1: (count IN, {0}), (count OUT, {1}); ControlNode2: (count IN, {2}), (count OUT, {3}).";
            String message = NLS.bind((String)messagePattern, (Object[])new Object[]{listcn1In.size(), listcn1Out.size(), listcn2In.size(), listcn2Out.size(), this.kind.toString()});
            boolean checkHasOneIN = false;
            if (this.kind == ControlNodeKind.ITERATE) {
                Assert.assertTrue((String)message, (listcn1In.size() >= 1 && listcn1Out.size() >= 1 && listcn2In.size() >= 1 && listcn2Out.size() >= 1 ? 1 : 0) != 0);
            } else {
                if (listcn1In.size() < 2 && listcn1Out.size() == 2) {
                    Assert.assertTrue((String)message, (listcn2In.size() == 2 ? 1 : 0) != 0);
                    checkHasOneIN = true;
                } else if (listcn2In.size() < 2 && listcn2Out.size() == 2) {
                    Assert.assertTrue((String)message, (listcn1In.size() == 2 ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((String)message, (boolean)false);
                }
                if (this.containerType == ControlNodeContainer.SEQUENCE_LINK) {
                    if (checkHasOneIN) {
                        Assert.assertTrue((String)("Invalid start ControlNode " + this.kind + " created, IN link missing"), (listcn1In.size() == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)"Invalid start ControlNode created, IN link missing", (listcn2Out.size() == 1 ? 1 : 0) != 0);
                    } else {
                        Assert.assertTrue((String)("Invalid end ControlNode" + this.kind + " created, IN link missing"), (listcn1Out.size() == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Invalid end ControlNode" + this.kind + " created, IN link missing"), (listcn2In.size() == 1 ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    protected class CreateControlNodeTool
    extends CreateAbstractDNodeTool<DNode> {
        protected ControlNodeContainer containerType;
        protected ControlNodeKind kind;

        public CreateControlNodeTool(DiagramContext context, String toolName, String containerView, ControlNodeKind kind) {
            super(context, toolName, containerView, DNode.class);
            this.containerType = ControlNodeContainer.DIAGRAM;
            this.kind = ControlNodeKind.OR;
            this.kind = kind;
        }

        public CreateControlNodeTool(DiagramContext context, String toolName, String targetView, String containerView, ControlNodeKind kind) {
            super(context, toolName, targetView, containerView, (String)null, DNode.class);
            this.containerType = ControlNodeContainer.DIAGRAM;
            this.kind = ControlNodeKind.OR;
            this.containerType = ControlNodeContainer.SEQUENCE_LINK;
            this.kind = kind;
        }

        protected Collection<DDiagramElement> getDiagramElements(DSemanticDecorator element) {
            return DiagramServices.getDiagramServices().getFlatOwnedDiagramElements((EObject)element);
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            DDiagram diagram = XFCDDiagram.this.getDiagram();
            DiagramHelper.refreshDiagram(diagram);
            DSemanticDecorator element = this.getContainerView();
            this.elements = this.getDiagramElements(element);
        }

        @Override
        protected void postRunTest() {
            this.newElements = this.getDiagramElements(this.getContainerView());
            this.newElements.removeAll(this.elements);
            ControlNode controlNode = null;
            for (DDiagramElement element : this.newElements) {
                if (!(element.getTarget() instanceof ControlNode)) continue;
                controlNode = (ControlNode)element.getTarget();
                if (this.containerType != ControlNodeContainer.SEQUENCE_LINK) continue;
                List listIn = SequenceLinkEndExt.getIncomingSequenceLinks((SequenceLinkEnd)controlNode);
                List listOut = SequenceLinkEndExt.getOutgoingSequenceLinks((SequenceLinkEnd)controlNode);
                Assert.assertTrue((String)"ControlNode should have one IN link", (listIn.size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)"ControlNode should have one OUT link", (listOut.size() == 1 ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"A new ControlNode is expected to be created", (controlNode != null ? 1 : 0) != 0);
        }
    }

    protected class CreateExchangeWithSequenceLinkTool
    extends CreateDEdgeTool {
        protected String selectedId;

        public CreateExchangeWithSequenceLinkTool(DiagramContext context, String toolName, String sourceViewId, String targetViewId, String selectedId) {
            super(context, toolName, sourceViewId, targetViewId, null, null, null);
            this.selectedId = selectedId;
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            HeadlessResultOpProvider.INSTANCE.setCurrentOp(new IHeadlessResult(){

                @Override
                public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                    return XFCDDiagram.this.getSessionContext().getSemanticElements(new String[]{CreateExchangeWithSequenceLinkTool.this.selectedId});
                }
            });
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            Set newLinks = this._newEdgesElements.stream().filter(x -> {
                if (x.getTarget() instanceof SequenceLink) {
                    SequenceLink link = (SequenceLink)x.getTarget();
                    return link.getSource().getId().equals(this._sourceView) && link.getTarget().getId().equals(this._targetView);
                }
                return false;
            }).collect(Collectors.toSet());
            Assert.assertTrue((String)"SequenceLink and association should have been created", (newLinks.size() >= 2 ? 1 : 0) != 0);
            Set newFEs = this._newEdgesElements.stream().filter(x -> {
                if (x.getTarget() instanceof FunctionalChainInvolvementLink) {
                    FunctionalChainInvolvementLink fe = (FunctionalChainInvolvementLink)x.getTarget();
                    return fe.getInvolved().getId().equals(this.selectedId) && fe.getSource().getId().equals(this._sourceView) && fe.getTarget().getId().equals(this._targetView);
                }
                return false;
            }).collect(Collectors.toSet());
            Assert.assertTrue((String)"FunctionalExchange should have been created", (!newFEs.isEmpty() ? 1 : 0) != 0);
        }
    }

    protected class CreateFunctionOnSequenceLinkTool
    extends CreateAbstractDNodeWithSelectionTool<DNode> {
        public CreateFunctionOnSequenceLinkTool(DiagramContext context, String toolName, String functionId, String targetView, String containerView) {
            super(context, toolName, targetView, containerView, functionId, DNode.class, SequenceLink.class);
        }

        protected Collection<DDiagramElement> getDiagramElements(DSemanticDecorator element) {
            return DiagramServices.getDiagramServices().getFlatOwnedDiagramElements((EObject)element);
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            DDiagram diagram = XFCDDiagram.this.getDiagram();
            DiagramHelper.refreshDiagram(diagram);
            DSemanticDecorator element = this.getContainerView();
            this.elements = this.getDiagramElements(element);
        }

        @Override
        protected void postRunTest() {
            this.newElements = this.getDiagramElements(this.getContainerView());
            this.newElements.removeAll(this.elements);
            Set newFunctions = this.newElements.stream().filter(x -> {
                if (x.getTarget() instanceof FunctionalChainInvolvementFunction) {
                    return ((FunctionalChainInvolvementFunction)x.getTarget()).getInvolved().getId().equals(this.selectedId);
                }
                return false;
            }).collect(Collectors.toSet());
            Assert.assertTrue((String)"A new FCIFunction is expected to be created", (!newFunctions.isEmpty() ? 1 : 0) != 0);
            FunctionalChainInvolvementFunction function = (FunctionalChainInvolvementFunction)((DDiagramElement)newFunctions.iterator().next()).getTarget();
            List sequenceLinksSource = SequenceLinkEndExt.getIncomingSequenceLinks((SequenceLinkEnd)function);
            Assert.assertTrue((String)"Function should be referenced by incoming SequenceLinks", (!sequenceLinksSource.isEmpty() ? 1 : 0) != 0);
            Set sourceLinks = sequenceLinksSource.stream().filter(x -> x.getId().equals(this.containerViewTarget)).collect(Collectors.toSet());
            Assert.assertTrue((String)"Function should be referenced by the given SequenceLink", (!sourceLinks.isEmpty() ? 1 : 0) != 0);
            List sequenceLinksTarget = SequenceLinkEndExt.getOutgoingSequenceLinks((SequenceLinkEnd)function);
            Assert.assertTrue((String)"Function should be referenced by outgoing SequenceLinks", (!sequenceLinksTarget.isEmpty() ? 1 : 0) != 0);
        }
    }

    protected class CreateSequenceLinkTool
    extends CreateDEdgeTool {
        public CreateSequenceLinkTool(DiagramContext context, String toolName, String sourceViewId, String targetViewId) {
            super(context, toolName, sourceViewId, targetViewId, null, null, null);
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            Set newLinks = this._newEdgesElements.stream().filter(x -> {
                if (x.getTarget() instanceof SequenceLink) {
                    SequenceLink link = (SequenceLink)x.getTarget();
                    return link.getSource().getId().equals(this._sourceView) && link.getTarget().getId().equals(this._targetView);
                }
                return false;
            }).collect(Collectors.toSet());
            Assert.assertTrue((String)"A new edge is expected to be created", (!newLinks.isEmpty() ? 1 : 0) != 0);
        }
    }

    protected class ExchangeTool
    extends CreateDEdgeTool {
        protected String functionalExchangeId;
        protected EObject functionalExchange;

        public ExchangeTool(DiagramContext context, String toolName, String sourceView, String targetView, String functionalExchangeid) {
            super(context, toolName, sourceView, targetView);
            this.functionalExchangeId = functionalExchangeid;
        }

        @Override
        protected void preRunTest() {
            this.functionalExchange = XFCDDiagram.this.getSessionContext().getSemanticElement(this.functionalExchangeId);
            Assert.assertTrue((boolean)(this.functionalExchange instanceof FunctionalExchange));
            HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
            super.preRunTest();
        }

        private IHeadlessResult createOperation() {
            return new IHeadlessResult(){

                @Override
                public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                    return Arrays.asList(ExchangeTool.this.functionalExchange);
                }
            };
        }

        @Override
        protected void postRunTest() {
            super.postRunTest();
            DEdge edge = this.getResult();
            EObject resultTarget = edge.getTarget();
            Assert.assertTrue((boolean)(resultTarget instanceof FunctionalChainInvolvementLink));
            FunctionalChainInvolvementLink involvementLink = (FunctionalChainInvolvementLink)resultTarget;
            Assert.assertEquals((Object)this.functionalExchange, (Object)involvementLink.getInvolved());
        }
    }

    protected class InsertInvolvementTool
    extends InsertRemoveTool {
        protected Set<DDiagramElement> preTestDiagramElements;
        protected Set<DDiagramElement> postTestDiagramElements;
        protected DDiagramElement resultDiagramElement;
        protected DSemanticDecorator containerView;

        public InsertInvolvementTool(DiagramContext context, String toolName, String targetId) {
            super(context, toolName, targetId);
            DSemanticDecorator targetView = XFCDDiagram.this.getView(targetId);
            this.preTestDiagramElements = Collections.emptySet();
            this.postTestDiagramElements = Collections.emptySet();
            this.containerView = targetView instanceof DNodeContainer || targetView instanceof DDiagram ? targetView : (DSemanticDecorator)targetView.eContainer();
        }

        @Override
        protected void checkPreconditions() {
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            this.preTestDiagramElements = new HashSet<DDiagramElement>((Collection<DDiagramElement>)DiagramServices.getDiagramServices().getOwnedDiagramElements((EObject)this.containerView));
        }

        @Override
        protected void postRunTest() {
            this.postTestDiagramElements = new HashSet<DDiagramElement>((Collection<DDiagramElement>)DiagramServices.getDiagramServices().getOwnedDiagramElements((EObject)this.containerView));
            this.postTestDiagramElements.removeAll(this.preTestDiagramElements);
            Set insertedInvolvementTargetIds = Stream.of(this.insertedElements).collect(Collectors.toSet());
            for (DDiagramElement newElement : this.postTestDiagramElements) {
                InvolvedElement involvedElement;
                EObject target = newElement.getTarget();
                if (!(target instanceof FunctionalChainInvolvement)) continue;
                FunctionalChainInvolvement involvement = (FunctionalChainInvolvement)target;
                Object object = involvedElement = involvement instanceof FunctionalChainReference ? ((FunctionalChainReference)involvement).getReferencedFunctionalChain() : involvement.getInvolved();
                if (!insertedInvolvementTargetIds.remove(involvedElement.getId())) continue;
                this.resultDiagramElement = newElement;
                break;
            }
            Assert.assertTrue((boolean)insertedInvolvementTargetIds.isEmpty());
        }

        public DDiagramElement getResult() {
            return this.resultDiagramElement;
        }
    }
}

