/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.delete.DeleteHookHelper;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.ToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DeleteElementTool
extends AbstractToolStep<EObject> {
    protected DDiagramElement _elementToDelete;

    public DeleteElementTool(DiagramContext context) {
        super(context, null);
    }

    @Deprecated
    public DeleteElementTool(DiagramContext context, DiagramContext containingToolDiagramContext, String toolName) {
        super(context, toolName);
    }

    public void delete(DDiagramElement element) {
        this.disableConfirmation();
        this._elementToDelete = element;
        DeleteHookHelper deleteHookHelper = new DeleteHookHelper(Arrays.asList(element));
        if (!deleteHookHelper.checkDeleteHook()) {
            Assert.assertTrue((boolean)false);
        }
        this.run();
    }

    private void disableConfirmation() {
        ScopedCapellaPreferencesStore.getInstance((String)"org.polarsys.capella.core.model.preferences").setDefault("Confirm_Delete", true);
        ScopedCapellaPreferencesStore.getInstance((String)"org.polarsys.capella.core.model.preferences").setValue("Confirm_Delete", false);
    }

    public void deleteAll() {
        this.disableConfirmation();
        TestHelper.getExecutionManager((Session)this.getExecutionContext().getSession()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Collection deletableElements = DeleteElementTool.this.getDiagramContext().getDiagram().getDiagramElements().stream().filter(x -> x.getDiagramElementMapping().getDeletionDescription() != null).collect(Collectors.toList());
                ArrayList<Command> commands = new ArrayList<Command>();
                DeleteHookHelper deleteHookHelper = new DeleteHookHelper(deletableElements);
                if (!deleteHookHelper.checkDeleteHook()) {
                    Assert.assertTrue((boolean)false);
                }
                Iterator iterator = deletableElements.iterator();
                while (iterator.hasNext()) {
                    DDiagramElement element;
                    DeleteElementTool.this._elementToDelete = element = (DDiagramElement)iterator.next();
                    DeleteElementTool.this.preRunTest();
                    Command cmd = DeleteElementTool.this._toolWrapper.createCommand();
                    if (UnexecutableCommand.INSTANCE.equals(cmd)) continue;
                    commands.add(cmd);
                }
                for (Command command : commands) {
                    command.execute();
                }
            }
        });
    }

    @Override
    protected void initToolArguments() {
        this._toolWrapper.setArgumentValue(ArgumentType.TARGET, this._elementToDelete);
        this._toolWrapper.setArgumentValue(ArgumentType.ON_DIAGRAM_ONLY, false);
    }

    public EObject getResult() {
        return null;
    }

    @Override
    protected void preRunTest() {
        this.toolName = this._elementToDelete.getDiagramElementMapping().getDeletionDescription().getName();
        DeleteElementDescription tool = this._elementToDelete.getDiagramElementMapping().getDeletionDescription();
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolDoesNotExist, (Object)this.toolName, (Object)this.getDiagramContext().getDiagram().getName()), (Object)tool);
        Assert.assertTrue((this.toolName != null && this.toolName == tool.getName() ? 1 : 0) != 0);
        this._toolWrapper = ToolWrapperFactory.INSTANCE.createToolCommandWrapper((AbstractToolDescription)tool);
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolWrapperNotAvailable, (Object)tool.getName()), (Object)this._toolWrapper);
        this.initToolArguments();
        boolean isArgumentOk = this._toolWrapper.isArgumentsAreSet();
        Assert.assertTrue((String)Messages.toolWrapperArgumentErr, (boolean)isArgumentOk);
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentValueErr, (Object)tool.getName()), (boolean)isContextOk);
    }

    protected void dispose() {
        super.dispose();
        this._elementToDelete = null;
    }
}

