/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InsertRemoveTool
extends AbstractToolStep {
    protected boolean initialized = false;
    protected boolean insertAll = false;
    protected boolean removeAll = false;
    protected boolean autoRefresh = true;
    protected String containerId;
    protected String[] toInsert;
    protected String[] toRemove;
    protected String[] insertedElements;
    protected String[] removedElements;
    protected EReference[] insertedReferencedElementsFeatures;
    protected EReference[] removedReferencedElementsFeatures;
    protected EReference[] insertedReferencingElementsFeatures;
    protected EReference[] removedReferencingElementsFeatures;

    public InsertRemoveTool(DiagramContext context, String toolName) {
        this(context, toolName, context.getDiagramId());
    }

    public InsertRemoveTool(DiagramContext context, String[] toolIdentifier) {
        this(context, toolIdentifier, context.getDiagramId());
    }

    public InsertRemoveTool(DiagramContext context, String toolName, String containerId) {
        super(context, toolName);
        this.containerId = containerId;
    }

    public InsertRemoveTool(DiagramContext context, String[] toolIdentifier, String containerId) {
        super(context, toolIdentifier[0], toolIdentifier[1]);
        this.containerId = containerId;
    }

    public InsertRemoveTool(DiagramContext context, String toolName, String containerId, boolean autoRefresh) {
        this(context, toolName, containerId);
        this.autoRefresh = autoRefresh;
    }

    protected void initialize(boolean insertAll, boolean removeAll) {
        this.insertAll = insertAll;
        this.removeAll = removeAll;
        this.initialize(null, null, null, null);
    }

    protected void initialize(String[] toInsert, String[] toRemove, String[] insertedElements, String[] removedElements) {
        this.toInsert = toInsert;
        if (toInsert == null) {
            this.toInsert = new String[0];
        }
        this.toRemove = toRemove;
        if (toRemove == null) {
            this.toRemove = new String[0];
        }
        this.insertedElements = insertedElements;
        if (insertedElements == null) {
            this.insertedElements = new String[0];
        }
        this.removedElements = removedElements;
        if (removedElements == null) {
            this.removedElements = new String[0];
        }
        this.initialized = true;
    }

    public Object run() {
        if (!this.initialized) {
            Assert.fail((String)"Please use insert/remove methods instead of run.");
        }
        return super.run();
    }

    public void insertAll() {
        this.initialize(true, false);
        this.run();
    }

    public void insert(String ... toInsert) {
        this.initialize(toInsert, null, toInsert, null);
        this.run();
    }

    public void insert(String[] toInsert, String[] insertedElements, String[] removedElements) {
        this.initialize(toInsert, null, insertedElements, removedElements);
        this.run();
    }

    public void remove(String ... toRemove) {
        this.initialize(null, toRemove, null, toRemove);
        this.run();
    }

    public void remove(String[] toRemove, String[] insertedElements, String[] removedElements) {
        this.initialize(null, toRemove, insertedElements, removedElements);
        this.run();
    }

    public void insertRemove(String[] toInsert, String[] toRemove, String[] insertedElements, String[] removedElements) {
        this.initialize(null, toRemove, insertedElements, removedElements);
        this.run();
    }

    protected void checkPreconditions() {
        String identifier;
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getDiagramContext().hasntView(identifier);
            ++n2;
        }
        stringArray = this.removedElements;
        n = this.removedElements.length;
        n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getDiagramContext().hasView(identifier);
            ++n2;
        }
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
        this.checkPreconditions();
        super.preRunTest();
    }

    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                if (InsertRemoveTool.this.insertAll) {
                    return AbstractExternalJavaAction.getScope(parameters);
                }
                if (InsertRemoveTool.this.removeAll) {
                    return Collections.emptyList();
                }
                HashSet<EObject> objects = new HashSet<EObject>();
                DiagramContext context = InsertRemoveTool.this.getDiagramContext();
                SessionContext sessionContext = context.getSessionContext();
                Collection<EObject> inserted = context.adaptTool(InsertRemoveTool.this, parameters, sessionContext.getSemanticElements(InsertRemoveTool.this.insertedElements));
                Collection<EObject> removed = context.adaptTool(InsertRemoveTool.this, parameters, sessionContext.getSemanticElements(InsertRemoveTool.this.removedElements));
                Collection initialSelection = AbstractExternalJavaAction.getInitialSelection(parameters);
                objects.addAll(initialSelection);
                objects.addAll(inserted);
                objects.removeAll(removed);
                if (removed.size() > 0) {
                    Assert.assertTrue((String)"All removed elements were not available on right pane", (boolean)initialSelection.containsAll(removed));
                }
                return new ArrayList(objects);
            }
        };
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator containerView = this.getDiagramContext().getView(this.containerId);
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, containerView.getTarget());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, containerView);
    }

    protected void postRunTest() {
        String identifier;
        super.postRunTest();
        if (this.autoRefresh) {
            DiagramHelper.refreshDiagram(this.getDiagramContext().getDiagram());
        }
        this.checkPostconditions();
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getDiagramContext().hasView(identifier);
            ++n2;
        }
        stringArray = this.removedElements;
        n = this.removedElements.length;
        n2 = 0;
        while (n2 < n) {
            identifier = stringArray[n2];
            this.getDiagramContext().hasntView(identifier);
            ++n2;
        }
    }

    protected void checkPostconditions() {
        this.initializeFeatures();
        if (this.insertedElements.length > 0) {
            if (this.insertedReferencedElementsFeatures != null) {
                this.insertedElements = this.applyReferencedFeatures(this.insertedReferencedElementsFeatures, this.insertedElements);
            } else if (this.insertedReferencingElementsFeatures != null) {
                this.insertedElements = this.applyReferencingFeatures(this.insertedReferencingElementsFeatures, this.insertedElements);
            }
        }
        if (this.removedElements.length > 0) {
            if (this.removedReferencedElementsFeatures != null) {
                this.removedElements = this.applyReferencedFeatures(this.removedReferencedElementsFeatures, this.removedElements);
            } else if (this.removedReferencingElementsFeatures != null) {
                this.removedElements = this.applyReferencingFeatures(this.removedReferencingElementsFeatures, this.removedElements);
            }
        }
    }

    protected String[] applyReferencedFeatures(EReference[] features, String ... elements) {
        EReference[] eReferenceArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EReference feature = eReferenceArray[n2];
            elements = this.getReferencedElements(feature, elements);
            ++n2;
        }
        return elements;
    }

    protected String[] applyReferencingFeatures(EReference[] features, String ... elements) {
        EReference[] eReferenceArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EReference feature = eReferenceArray[n2];
            elements = this.getReferencingElements(feature, elements);
            ++n2;
        }
        return elements;
    }

    protected String[] getReferencedElements(EReference feature, String ... elements) {
        HashSet<CapellaElement> objs = new HashSet<CapellaElement>();
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            EObject obj = this.getExecutionContext().getSemanticElement(element);
            Object object = obj.eGet((EStructuralFeature)feature);
            if (object instanceof EList) {
                objs.addAll((Collection<CapellaElement>)((EList)object));
            } else if (object instanceof CapellaElement) {
                objs.add((CapellaElement)object);
            }
            ++n2;
        }
        return this.filterResults(objs);
    }

    protected String[] getReferencingElements(EReference feature, String ... elements) {
        HashSet<CapellaElement> objs = new HashSet<CapellaElement>();
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            objs.addAll(EObjectExt.getReferencers((EObject)this.getExecutionContext().getSemanticElement(element), (EReference)feature).stream().collect(Collectors.toList()));
            ++n2;
        }
        return this.filterResults(objs);
    }

    protected String[] filterResults(Collection<CapellaElement> objs) {
        DRepresentationDescriptor cRDescriptor = this.getDiagramContext().getDiagramDescriptor();
        String[] results = (String[])objs.stream().filter(x -> x.eContainer() == cRDescriptor.getTarget()).map(x -> x.getId()).toArray(String[]::new);
        Assert.assertTrue((results.length > 0 ? 1 : 0) != 0);
        return results;
    }

    protected void initializeFeatures() {
    }

    public Object getResult() {
        return null;
    }
}

