/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;

public final class MultiInstanceRoleTool
extends AbstractToolStep<InstanceRole> {
    private Collection<DDiagramElement> preExecutionElements;
    private Part partToInsert;
    private InstanceRole result;

    private MultiInstanceRoleTool(DiagramContext context, String toolName, Part partToInsert) {
        super(context, toolName);
        this.partToInsert = partToInsert;
    }

    public static InstanceRole newInstanceRole(DiagramContext context, String representedPartId) {
        EObject diagramTarget = ((DSemanticDecorator)context.getDiagram()).getTarget();
        BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)diagramTarget);
        Part part = (Part)context.getSessionContext().getSemanticElement(representedPartId);
        String toolName = null;
        Matcher diagramDescriptionName = null;
        if (ba.eClass() == OaPackage.Literals.OPERATIONAL_ANALYSIS) {
            diagramDescriptionName = IsEqual.equalTo((Object)"Operational Interaction Scenario");
            toolName = "add.multiple.lifelines.for.an.existing.entity.actor";
        } else {
            diagramDescriptionName = AnyOf.anyOf((Matcher)IsEqual.equalTo((Object)"Component Interfaces Scenario"), (Matcher)IsEqual.equalTo((Object)"Component Exchanges Scenario"));
            toolName = ComponentExt.isActor((EObject)part.getAbstractType()) ? "add.multiple.lifelines.for.an.existing.actor" : "add.multiple.lifelines.for.an.existing.component";
        }
        Assert.assertThat((Object)context.getDiagram().getDescription().getName(), (Matcher)diagramDescriptionName);
        MultiInstanceRoleTool tool = new MultiInstanceRoleTool(context, toolName, part);
        return (InstanceRole)tool.run();
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator containerView = this.getDiagramContext().getView(this.getDiagramContext().getDiagramId());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, containerView.getTarget());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, containerView);
    }

    protected void postRunTest() {
        ArrayList now = new ArrayList(this.getDiagramContext().getDiagram().getOwnedDiagramElements());
        now.removeAll(this.preExecutionElements);
        Assert.assertEquals((long)1L, (long)now.size());
        DDiagramElement elem = (DDiagramElement)now.get(0);
        Assert.assertTrue((boolean)(elem.getTarget() instanceof InstanceRole));
        Assert.assertSame((Object)this.partToInsert, (Object)((InstanceRole)elem.getTarget()).getRepresentedInstance());
        this.result = (InstanceRole)elem.getTarget();
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
        this.preExecutionElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)this.getDiagramContext().getDiagram().getOwnedDiagramElements());
        super.preRunTest();
    }

    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                Iterable scope = (Iterable)parameters.get("scope");
                Assert.assertThat((Object)scope, (Matcher)IsCollectionContaining.hasItem((Object)MultiInstanceRoleTool.this.partToInsert));
                return MultiInstanceRoleTool.this.partToInsert;
            }
        };
    }

    public InstanceRole getResult() {
        return this.result;
    }
}

