/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.junit.Assert;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.TitleBlockServices;
import org.polarsys.capella.core.sirius.analysis.preferences.TitleBlockPreferencesInitializer;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;

public class CreateDiagramTitleBlockTool
extends CreateAbstractDNodeTool<DDiagramElementContainer> {
    public CreateDiagramTitleBlockTool(DiagramContext context, String toolName, String containerView) {
        super(context, toolName, containerView);
    }

    protected Collection<DDiagramElement> getDiagramElements(DSemanticDecorator element) {
        return DiagramServices.getDiagramServices().getFlatOwnedDiagramElements((EObject)element);
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
    }

    @Override
    protected void postRunTest() {
        this.newElements = this.getDiagramElements(this.getContainerView());
        this.newElements.removeAll(this.elements);
        Assert.assertFalse((boolean)this.newElements.isEmpty());
        DDiagramElement element = this.newElements.stream().filter(x -> x.getTarget() instanceof DAnnotation && ((DAnnotation)x.getTarget()).getSource().equals("DiagramTitleBlock")).findFirst().get();
        Assert.assertTrue((element != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(element.getTarget() instanceof DAnnotation));
        DAnnotation titleBlock = (DAnnotation)element.getTarget();
        Assert.assertTrue((boolean)titleBlock.getSource().equals("DiagramTitleBlock"));
        int numLines = TitleBlockPreferencesInitializer.getLinesNumber();
        int numCols = TitleBlockPreferencesInitializer.getColumnsNumber();
        List lines = TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlock);
        Assert.assertTrue((numLines == lines.size() ? 1 : 0) != 0);
        List columns = TitleBlockHelper.getTitleBlockCells((DAnnotation)((DAnnotation)lines.get(0)));
        Assert.assertTrue((numCols == columns.size() ? 1 : 0) != 0);
    }

    @Override
    public DDiagramElementContainer getResult() {
        return (DDiagramElementContainer)this.newElements.iterator().next();
    }

    @Override
    public void contextOk() {
        super.contextOk();
        Assert.assertTrue((boolean)TitleBlockServices.getService().isValidCreateDiagramTitleBlock((EObject)this.getDiagramContext().getDiagram()));
    }

    public void checkAutocreate() {
        super.contextOk();
        Assert.assertTrue((TitleBlockServices.getService().hasADiagramTitleBlock(this.getDiagramContext().getDiagram()) && !TitleBlockServices.getService().getVisibleDiagramTitleBlocks((Object)this.getDiagramContext().getDiagram()).isEmpty() ? 1 : 0) != 0);
    }
}

