/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.factory;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.tools.api.command.TableCommandFactoryService;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.AbstractToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.table.AbstractTableToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.table.CreateCellToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.table.CreateLineToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.table.DeleteTableElementToolWrapper;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class TableToolWrapperFactory
extends AbstractToolWrapperFactory {
    @Override
    public EPackage getTargetEPackage() {
        return DescriptionPackage.eINSTANCE;
    }

    @Override
    public ICommandFactory getDefaultCommandFactory() {
        TransactionalEditingDomain editingDomain = TestHelper.getEditingDomain();
        if (editingDomain == null) {
            ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
            editingDomain = manager.getEditingDomain();
        }
        return TableCommandFactoryService.getInstance().getNewProvider().getCommandFactory(editingDomain);
    }

    @Override
    public AbstractToolWrapper createToolCommandWrapper(AbstractToolDescription tool_p, ICommandFactory cmdFactory_p) {
        ResourceSet rs;
        Assert.isNotNull((Object)tool_p);
        Assert.isTrue((boolean)(cmdFactory_p instanceof ITableCommandFactory));
        ITableCommandFactory commandFactory = (ITableCommandFactory)cmdFactory_p;
        if (TestHelper.getEditingDomain() == null) {
            ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
            rs = manager.getEditingDomain().getResourceSet();
        } else {
            rs = TestHelper.getEditingDomain().getResourceSet();
        }
        commandFactory.setModelAccessor(SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(rs));
        AbstractTableToolWrapper result = null;
        EClass eclass = tool_p.eClass();
        switch (eclass.getClassifierID()) {
            case 17: {
                result = new CreateCellToolWrapper(tool_p, commandFactory);
                break;
            }
            case 16: {
                result = new CreateLineToolWrapper(tool_p, commandFactory);
                break;
            }
            case 14: {
                break;
            }
            case 19: 
            case 20: {
                result = new DeleteTableElementToolWrapper(tool_p, commandFactory);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

