/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.cii;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ShowHideCIIActorQuery
extends AbstractDiagramTestCase {
    private String CII_DIAGRAM = "[CII] LC 1";
    public static final String LOGICAL_SYSTEM_LA_2 = "928cede2-ba3c-488f-8a5a-a173edf6272b";
    public static final String LC_PKG_1_LA_2 = "af4ec62d-4b16-45a1-a2b5-44b1620f1d5e";
    public static final String LA_1 = "9c822925-b126-403c-8c35-ebe1c05f79d5";
    public static final String LOGICAL_SYSTEM_LC_1_LA_1 = "224ef6ae-539a-4a84-b8e6-2720e5f721cf";
    public static final String LOGICAL_SYSTEM_LC_1 = "7f544336-d382-40a9-8cd3-156414b8f4e6";

    protected String getRequiredTestModel() {
        return "ContextualInterface";
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, this.CII_DIAGRAM).run();
        DDiagram ciiDiagram = diagramContext.getDiagram();
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        EObject logicalSystem_la2 = IdManager.getInstance().getEObject(LOGICAL_SYSTEM_LA_2, (IScope)scope);
        EObject lcPkg1_la2 = IdManager.getInstance().getEObject(LC_PKG_1_LA_2, (IScope)scope);
        EObject la1 = IdManager.getInstance().getEObject(LA_1, (IScope)scope);
        EObject logicalSystem_lc1_la1 = IdManager.getInstance().getEObject(LOGICAL_SYSTEM_LC_1_LA_1, (IScope)scope);
        EObject logicalSystem_lc1 = IdManager.getInstance().getEObject(LOGICAL_SYSTEM_LC_1, (IScope)scope);
        if (ciiDiagram instanceof DSemanticDiagram) {
            Collection actorScope = CsServices.getService().getCCIIShowHideActor((DSemanticDecorator)((DSemanticDiagram)ciiDiagram));
            ShowHideCIIActorQuery.assertTrue((String)"The scope of Show/Hide CEI actors is not correct", (actorScope.size() == 3 && actorScope.contains(logicalSystem_la2) && actorScope.contains(lcPkg1_la2) && actorScope.contains(la1) ? 1 : 0) != 0);
            Optional<DDiagramElement> lc1Opt = ciiDiagram.getDiagramElements().stream().filter(e -> e.getTarget() == logicalSystem_lc1).findFirst();
            if (lc1Opt.isPresent()) {
                DDiagramElement lc1Container = lc1Opt.get();
                Collection actorScopeForLC1 = CsServices.getService().getCCIIShowHideActor((DSemanticDecorator)lc1Container);
                ShowHideCIIActorQuery.assertTrue((String)"The scope of Show/Hide CEI actors is not correct", (actorScopeForLC1.size() == 1 && actorScopeForLC1.contains(logicalSystem_lc1_la1) ? 1 : 0) != 0);
            }
        }
    }
}

