/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.framework.context.SessionContext;

public class BlackInternalLinks
extends AbstractDiagramTestCase {
    public String getRequiredTestModel() {
        return BlackInternalLinks.class.getSimpleName();
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.odesignMappings(session);
        this.internalLinksProperlyMerged(session, context);
        this.refreshAllNonDirty(session, context);
    }

    private void refreshAllNonDirty(Session session, SessionContext context) {
        session.save((IProgressMonitor)new NullProgressMonitor());
        for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
            DiagramContext dc = new DiagramContext(context, (DDiagram)descriptor.getRepresentation());
            dc.open();
            dc.refreshDiagram();
            dc.close();
        }
        BlackInternalLinks.assertTrue((boolean)SessionStatus.SYNC.equals((Object)session.getStatus()));
    }

    private void internalLinksProperlyMerged(Session session, SessionContext context) {
        for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
            DiagramContext dc = new DiagramContext(context, (DDiagram)descriptor.getRepresentation());
            dc.open();
            dc.refreshDiagram();
            HashSet<String> bounds = new HashSet<String>();
            for (DEdge edge : dc.getDiagram().getEdges()) {
                if (!(edge.getTarget() instanceof FunctionalChain) && !(edge.getTarget() instanceof PhysicalPath)) continue;
                String key = Arrays.asList(edge.getSourceNode().getUid(), edge.getTargetNode().getUid()).stream().sorted().collect(Collectors.joining(":"));
                if (bounds.contains(key)) {
                    System.err.println(String.valueOf(dc.getDiagram().getName()) + " diagram internal links not merged");
                }
                bounds.add(key);
            }
            dc.close();
        }
    }

    public void odesignMappings(Session session) {
        HashSet<DiagramElementMapping> mappings = new HashSet<DiagramElementMapping>();
        for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
            for (DEdge edge : ((DDiagram)descriptor.getRepresentation()).getEdges()) {
                if (!(edge.getTarget() instanceof FunctionalChain) && !(edge.getTarget() instanceof PhysicalPath)) continue;
                mappings.add(edge.getDiagramElementMapping());
            }
        }
        for (DiagramElementMapping mapping : mappings) {
            BlackInternalLinks.assertTrue((mapping.getSemanticElements().equals("aql:view.getPPInternalLinkSemanticElements()") || mapping.getSemanticElements().equals("aql:view.getFCInternalLinkSemanticElements()") ? 1 : 0) != 0);
        }
    }
}

