/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DnDWithInternalFEAndCommonPort
extends EmptyProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        XDFBDiagram sdfbDiagram = XDFBDiagram.createDiagram((SessionContext)context, (String)"f875adac-b475-4f56-8ef5-0f7d3cc43347");
        String function1Id = sdfbDiagram.createContainer(sdfbDiagram.getDiagramId(), XDFBCreateContainerTools.CREATE_FUNCTION);
        String function2Id = sdfbDiagram.createContainer(sdfbDiagram.getDiagramId(), XDFBCreateContainerTools.CREATE_FUNCTION);
        String function3Id = sdfbDiagram.createContainer(sdfbDiagram.getDiagramId(), XDFBCreateContainerTools.CREATE_FUNCTION);
        String fe1Id = sdfbDiagram.createEdge(function1Id, function2Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        String fe2Id = sdfbDiagram.createEdge(function1Id, function3Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        DnDWithInternalFEAndCommonPort.assertNotNull((String)"FE expected between Function 1 and Function 2", (Object)sdfbDiagram.getView(fe1Id));
        DnDWithInternalFEAndCommonPort.assertNotNull((String)"FE expected between Function 1 and Function 3", (Object)sdfbDiagram.getView(fe2Id));
        String function1OutputPort1ID = ((FunctionalExchange)sdfbDiagram.getSessionContext().getSemanticElement(fe1Id)).getSource().getId();
        String function1OutputPort2ID = ((FunctionalExchange)sdfbDiagram.getSessionContext().getSemanticElement(fe2Id)).getSource().getId();
        new ReconnectTool((DiagramContext)sdfbDiagram, "SDFB Reconnect Exchanges", fe2Id, function1OutputPort2ID, function1OutputPort1ID).run();
        DnDWithInternalFEAndCommonPort.assertEquals((String)"FOP 1 of SF1 must have 2 outgoingEdges", (int)2, (int)((EdgeTarget)sdfbDiagram.getView(function1OutputPort1ID)).getOutgoingEdges().size());
        DnDWithInternalFEAndCommonPort.assertEquals((String)"FOP 2 of SF1 must have 0 outgoingEdges", (int)0, (int)((EdgeTarget)sdfbDiagram.getView(function1OutputPort2ID)).getOutgoingEdges().size());
        new DragAndDropTool((DiagramContext)sdfbDiagram, "DnD DF AbstractFunction", function2Id, function1Id).run();
        DnDWithInternalFEAndCommonPort.assertNull((String)"No FE expected between Function 1 and Function 2 (internal exchange)", (Object)sdfbDiagram.getView(fe1Id));
        DnDWithInternalFEAndCommonPort.assertNotNull((String)"FE expected between Function 1 and Function 3", (Object)sdfbDiagram.getView(fe2Id));
    }
}

