/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.FSDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.ISDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DragAndDropTest
extends SequenceTest {
    public void test() throws Exception {
        BlockArchitectureExt.Type[] typesES = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        BlockArchitectureExt.Type[] typesFS = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        BlockArchitectureExt.Type[] typesIS = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(typesES, SequenceTest.SequenceType.ES);
        this.testOnAllLevels(typesFS, SequenceTest.SequenceType.FS);
        this.testOnAllLevels(typesIS, SequenceTest.SequenceType.IS);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
        XABDiagram setupDiagram = this.xabSetupDiagram(type);
        if (diagram instanceof ESDiagram) {
            this.testDragandDropComponentES(diagram, setupDiagram, type);
        } else if (diagram instanceof FSDiagram) {
            this.testDragandDropComponentFS(diagram, setupDiagram);
        } else if (diagram instanceof ISDiagram) {
            this.testDragandDropComponentIS(diagram, setupDiagram);
        }
        this.testDragandDropConstraint(diagram, setupDiagram, type);
    }

    private void testDragandDropComponentES(SequenceDiagram diagram, XABDiagram setupDiagram, BlockArchitectureExt.Type type) {
        String component = setupDiagram.createActor("a1");
        if (type != BlockArchitectureExt.Type.OA) {
            Part partObj = (Part)setupDiagram.getSessionContext().getSemanticElement(component);
            component = partObj.getAbstractType().getId();
        }
        diagram.dragAndDropComponentFromExplorer(component, diagram.getDiagramId());
    }

    private void testDragandDropComponentFS(SequenceDiagram diagram, XABDiagram setupDiagram) {
        String container = setupDiagram.createActor("a1");
        String function = setupDiagram.createFunction("f1", container);
        diagram.dragAndDropComponentFromExplorer(function, diagram.getDiagramId());
    }

    private void testDragandDropComponentIS(SequenceDiagram diagram, XABDiagram setupDiagram) {
        String component = setupDiagram.createActor("a1");
        Part partObj = (Part)setupDiagram.getSessionContext().getSemanticElement(component);
        component = partObj.getAbstractType().getId();
        diagram.dragAndDropComponentFromExplorer(component, diagram.getDiagramId());
    }

    private void testDragandDropConstraint(SequenceDiagram diagram, XABDiagram setupDiagram, BlockArchitectureExt.Type type) {
        String constraint = setupDiagram.createConstraint("cn1");
        if (type != BlockArchitectureExt.Type.OA) {
            diagram.dragAndDropConstraintFromExplorer(constraint, diagram.getDiagramId());
        } else {
            diagram.dragAndDropConstraintsFromExplorer(constraint, diagram.getDiagramId());
        }
    }

    private XABDiagram xabSetupDiagram(BlockArchitectureExt.Type type) {
        String xabTargetId = "";
        switch (type) {
            case OA: {
                xabTargetId = "bba24bed-20cd-4d6e-b981-12de37a4926d";
                break;
            }
            case SA: {
                xabTargetId = "b121dd59-9d3f-4c21-94ae-87e957aaa2a9";
                break;
            }
            case LA: {
                xabTargetId = "32f06455-48c7-4d68-aea5-cf397ab4aff2";
                break;
            }
            case PA: {
                xabTargetId = "16953dc7-be25-45ef-9da9-32869d0cb53f";
                break;
            }
        }
        return XABDiagram.createDiagram((SessionContext)this.context, (String)xabTargetId);
    }
}

