/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.tools.RenameTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ToolHelper;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class ConstraintRename
extends XABDiagramsProject {
    public static String RENAME_CONSTRAINT_TOOL = "Constraint Content";
    public static String NEW_NAME = "New Constraint";

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXAB(session, context, "[EAB] System", BlockArchitectureExt.Type.EPBS);
        this.testOnXAB(session, context, "[OAB] Operational Context", BlockArchitectureExt.Type.OA);
        this.testOnXAB(session, context, "[SAB] System", BlockArchitectureExt.Type.SA);
        this.testOnXAB(session, context, "[LAB] Logical System", BlockArchitectureExt.Type.LA);
        this.testOnXAB(session, context, "[PAB] Physical System", BlockArchitectureExt.Type.PA);
    }

    public void testOnXAB(final Session session, SessionContext context, String diagramName, BlockArchitectureExt.Type type) {
        XABDiagram xabDiagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        final CDBDiagram cdbDiagram = CDBDiagram.createDiagram((SessionContext)context, (String)"cb34448a-cdbf-46af-b02d-56303ca5e0ce");
        ToolHelper toolhelper = new ToolHelper(session, cdbDiagram.getDiagram());
        AbstractToolDescription tool = toolhelper.getTool(RENAME_CONSTRAINT_TOOL);
        ConstraintRename.assertTrue((String)"Rename tool has not been found", (tool != null && tool instanceof DirectEditLabel ? 1 : 0) != 0);
        DirectEditLabel renameTool = (DirectEditLabel)tool;
        ConstraintRename.assertTrue((String)"Constraint's name should be displayed when rename tool is applied", (renameTool.getInputLabelExpression() != null && renameTool.getInputLabelExpression().equals("feature:name") ? 1 : 0) != 0);
        xabDiagram.createConstraint(GenericModel.CONSTRAINT_1);
        Constraint constraint = (Constraint)xabDiagram.getSessionContext().getSemanticElement(GenericModel.CONSTRAINT_1);
        new RenameTool((DiagramContext)xabDiagram, RENAME_CONSTRAINT_TOOL, (EObject)constraint, NEW_NAME){

            protected AbstractToolDescription getRenameTool() {
                ToolHelper toolhelper = new ToolHelper(session, cdbDiagram.getDiagram());
                AbstractToolDescription tool = toolhelper.getTool(RENAME_CONSTRAINT_TOOL);
                return tool;
            }
        }.run();
        ConstraintRename.assertTrue((String)"The constraint has not been renamed", (boolean)constraint.getName().equals(NEW_NAME));
    }
}

