/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreateComponentExchangeGroup
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testCreateComponentExchange(context);
        this.testCreateComponentExchangeDelegation(context);
        this.testCreateComponentExchangeWithPorts(context);
        this.testCreateComponentExchangeWithoutPorts(context);
        this.testCreateComponentExchangeBetweenTypes(context);
    }

    public void testCreateComponentExchange(SessionContext context) {
        this.testOnXAB_CreateComponentExchange(context, "[OAB] Operational Context", BlockArchitectureExt.Type.OA, "6ce78848-33e3-4cde-96cf-0248225456e4", "00583700-90af-48dc-be0a-dffca68ac815", null, null);
        this.testOnXAB_CreateComponentExchange(context, "[SAB] System", BlockArchitectureExt.Type.SA, "ff952c1b-4605-414e-892b-7fc1e0886826", "325e94ec-99cd-47ef-b1f0-8fa15fb50ca2", "1976fbc0-8f98-41e3-9987-7893f631b739", "fdb697c6-2c61-4717-8837-6ddc612f8f51");
        this.testOnXAB_CreateComponentExchange(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", "2c64e0ff-1d69-4348-acc7-ad8ee3d731a2", "80df6258-ebfd-4cee-8771-1ac8a254fd1a");
        this.testOnXAB_CreateComponentExchange(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "5d473c23-8048-400b-97c0-bc8f6b1e58a3", "7f2f46d0-9e76-418c-bd18-1d6845221d4b", "7a718948-aa24-42ab-b057-80327eb1da43", "c668b546-0d61-4ccc-ae08-d694406d1f2c");
    }

    public void testCreateComponentExchangeDelegation(SessionContext context) {
        this.testOnXAB_CreateComponentExchangeDelegation(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "6b64bc6d-7666-4202-8727-bb039a76d172", "c30f774e-9dd2-406e-a611-14f59ebcb96c", "5a4ce002-7f24-4d62-a43d-b890afb6cae6", "f5838490-ddc0-4410-aa96-b850f49e2aa9");
        this.testOnXAB_CreateComponentExchangeDelegation(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "5d473c23-8048-400b-97c0-bc8f6b1e58a3", "ce826b8b-19e8-4f83-89cc-74f65b553f79", "7a718948-aa24-42ab-b057-80327eb1da43", "893cb5bf-e42b-4f69-bf1c-3e70bc3996bb");
    }

    public void testCreateComponentExchangeWithPorts(SessionContext context) {
        this.testOnXAB_CreateComponentExchangeWithPorts(context, "[SAB] System", BlockArchitectureExt.Type.SA, "ff952c1b-4605-414e-892b-7fc1e0886826", "325e94ec-99cd-47ef-b1f0-8fa15fb50ca2");
        this.testOnXAB_CreateComponentExchangeWithPorts(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0");
        this.testOnXAB_CreateComponentExchangeWithPorts(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "5d473c23-8048-400b-97c0-bc8f6b1e58a3", "7f2f46d0-9e76-418c-bd18-1d6845221d4b");
    }

    public void testCreateComponentExchangeWithoutPorts(SessionContext context) {
        this.testOnXAB_CreateComponentExchangeWithoutPorts(context, "[SAB] System", BlockArchitectureExt.Type.SA, "ff952c1b-4605-414e-892b-7fc1e0886826", "325e94ec-99cd-47ef-b1f0-8fa15fb50ca2");
        this.testOnXAB_CreateComponentExchangeWithoutPorts(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0");
        this.testOnXAB_CreateComponentExchangeWithoutPorts(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "5d473c23-8048-400b-97c0-bc8f6b1e58a3", "7f2f46d0-9e76-418c-bd18-1d6845221d4b");
    }

    public void testCreateComponentExchangeBetweenTypes(SessionContext context) {
        this.testOnXAB_CreateComponentExchangeBetweenTypes(context, "[SAB] System", BlockArchitectureExt.Type.SA, "ff952c1b-4605-414e-892b-7fc1e0886826", "325e94ec-99cd-47ef-b1f0-8fa15fb50ca2");
        this.testOnXAB_CreateComponentExchangeBetweenTypes(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0");
        this.testOnXAB_CreateComponentExchangeBetweenTypes(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "5d473c23-8048-400b-97c0-bc8f6b1e58a3", "7f2f46d0-9e76-418c-bd18-1d6845221d4b");
    }

    public void testOnXAB_CreateComponentExchange(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String compSourceId, String compTargetId, String portSourceId, String portTargetId) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.createComponentExchange(compSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_1);
        if (type != BlockArchitectureExt.Type.OA) {
            diagram.createComponentExchange(compSourceId, portTargetId, GenericModel.COMPONENT_EXCHANGE_2);
            diagram.createComponentExchange(portSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_3);
            diagram.createComponentExchange(portSourceId, portTargetId, GenericModel.COMPONENT_EXCHANGE_4);
        }
    }

    public void testOnXAB_CreateComponentExchangeDelegation(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String compSourceId, String compTargetId, String portSourceId, String portTargetId) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.createComponentExchangeDelegation(compSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_1);
        diagram.createComponentExchangeWithDelegation(compSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_2);
        diagram.createComponentExchangeDelegation(compSourceId, portTargetId, GenericModel.COMPONENT_EXCHANGE_4);
        diagram.createComponentExchangeWithDelegation(compSourceId, portTargetId, GenericModel.COMPONENT_EXCHANGE_5);
        diagram.createComponentExchangeDelegation(portSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_6);
        if (type == BlockArchitectureExt.Type.PA) {
            diagram.createComponentExchangeWithDelegation(portSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_7);
        }
        diagram.createComponentExchangeDelegation(portSourceId, portTargetId, GenericModel.COMPONENT_EXCHANGE_8);
        if (type == BlockArchitectureExt.Type.PA) {
            diagram.createComponentExchangeWithDelegation(portSourceId, portTargetId, GenericModel.COMPONENT_EXCHANGE_9);
        }
    }

    public void testOnXAB_CreateComponentExchangeWithPorts(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String compSourceId, String compTargetId) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.createComponentExchangeWithPorts(compSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_1);
    }

    public void testOnXAB_CreateComponentExchangeWithoutPorts(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String compSourceId, String compTargetId) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.createComponentExchangeWithoutPorts(compSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_1);
    }

    public void testOnXAB_CreateComponentExchangeBetweenTypes(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String compSourceId, String compTargetId) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.createComponentExchangeBetweenTypes(compSourceId, compTargetId, GenericModel.COMPONENT_EXCHANGE_1);
    }
}

