/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.refmap.Pair;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropFromProjectExplorerTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DragAndDropPhysicalComponent
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testDnDComponentsFromProjectExplorer(context);
        this.testDnDComponentsBehaviorAndNodeDeployedOrNot(session, context);
    }

    public void testDnDComponentsFromProjectExplorer(SessionContext context) {
        this.testOnXAB(context, "[PAB] Physical System", "[PAB] Physical System", "d74876b1-f561-46ae-8ee7-638f2c9cacea");
        this.testOnXAB(context, "[PAB] Physical System", "6f03c5ec-9bc4-4ba9-b162-e2b37e757d94", "49f7adeb-3637-4d1e-a216-a9a511a35ccf");
        this.testOnXAB(context, "[PAB] PC 2", "[PAB] PC 2", "6f03c5ec-9bc4-4ba9-b162-e2b37e757d94");
        this.testOnXAB(context, "[PAB] PC 2", "6f03c5ec-9bc4-4ba9-b162-e2b37e757d94", "49f7adeb-3637-4d1e-a216-a9a511a35ccf");
    }

    public void testOnXAB(SessionContext context, String diagramName, String containerId, String id) {
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, diagramName).run();
        EObject pc = context.getSemanticElement(id);
        new DragAndDropFromProjectExplorerTool(diagramContext, "D&D Components From Project Explorer", pc, containerId).run();
    }

    public void testDnDComponentsBehaviorAndNodeDeployedOrNot(Session session, SessionContext context) throws Exception {
        ArrayList<String> draggedElements = new ArrayList<String>();
        ArrayList<String> containerElements = new ArrayList<String>();
        String NOT_DEPLOYED_NODE_DRAGGED = "6f03c5ec-9bc4-4ba9-b162-e2b37e757d94";
        String NOT_DEPLOYED_NODE_CONTAINER = "f2cb610a-e6a1-4001-9d3e-d9108d6d7091";
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isNotDeployedNode(context, NOT_DEPLOYED_NODE_DRAGGED));
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isNotDeployedNode(context, NOT_DEPLOYED_NODE_CONTAINER));
        draggedElements.add(NOT_DEPLOYED_NODE_DRAGGED);
        containerElements.add(NOT_DEPLOYED_NODE_CONTAINER);
        String DEPLOYED_NODE_DRAGGED = "fdacc723-f8bc-4a99-b678-4c72d24098a9";
        String DEPLOYED_NODE_CONTAINER = "fdacc723-f8bc-4a99-b678-4c72d24098a9";
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isDeployedNode(context, DEPLOYED_NODE_DRAGGED));
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isDeployedNode(context, DEPLOYED_NODE_CONTAINER));
        draggedElements.add(DEPLOYED_NODE_DRAGGED);
        containerElements.add(DEPLOYED_NODE_CONTAINER);
        String NOT_DEPLOYED_BEHAVIOR_DRAGGED = "79a754d4-99a4-4c7f-857d-aec9c0388232";
        String NOT_DEPLOYED_BEHAVIOR_CONTAINER = "79a754d4-99a4-4c7f-857d-aec9c0388232";
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isNotDeployedBehavior(context, NOT_DEPLOYED_BEHAVIOR_DRAGGED));
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isNotDeployedBehavior(context, NOT_DEPLOYED_BEHAVIOR_CONTAINER));
        draggedElements.add(NOT_DEPLOYED_BEHAVIOR_DRAGGED);
        containerElements.add(NOT_DEPLOYED_BEHAVIOR_CONTAINER);
        String DEPLOYED_BEHAVIOR_DRAGGED = "7f2f46d0-9e76-418c-bd18-1d6845221d4b";
        String DEPLOYED_BEHAVIOR_CONTAINER = "b61cce74-4df1-4c35-b52f-107a1a41236e";
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isDeployedBehavior(context, DEPLOYED_BEHAVIOR_DRAGGED));
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isDeployedBehavior(context, DEPLOYED_BEHAVIOR_CONTAINER));
        draggedElements.add(DEPLOYED_BEHAVIOR_DRAGGED);
        containerElements.add(DEPLOYED_BEHAVIOR_CONTAINER);
        String ACTOR_DRAGGED = "053143f1-d4fe-4f85-8f21-58720afa63db";
        String ACTOR_CONTAINER = "053143f1-d4fe-4f85-8f21-58720afa63db";
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isActor(context, ACTOR_DRAGGED));
        DragAndDropPhysicalComponent.assertTrue((boolean)this.isActor(context, ACTOR_CONTAINER));
        draggedElements.add(ACTOR_DRAGGED);
        containerElements.add(ACTOR_CONTAINER);
        ArrayList<Pair> expectedNotPossible = new ArrayList<Pair>();
        expectedNotPossible.add(new Pair((Object)NOT_DEPLOYED_NODE_DRAGGED, (Object)NOT_DEPLOYED_BEHAVIOR_CONTAINER));
        expectedNotPossible.add(new Pair((Object)NOT_DEPLOYED_NODE_DRAGGED, (Object)DEPLOYED_BEHAVIOR_CONTAINER));
        expectedNotPossible.add(new Pair((Object)DEPLOYED_NODE_DRAGGED, (Object)NOT_DEPLOYED_BEHAVIOR_CONTAINER));
        expectedNotPossible.add(new Pair((Object)DEPLOYED_NODE_DRAGGED, (Object)DEPLOYED_BEHAVIOR_CONTAINER));
        expectedNotPossible.add(new Pair((Object)NOT_DEPLOYED_BEHAVIOR_DRAGGED, (Object)NOT_DEPLOYED_NODE_CONTAINER));
        expectedNotPossible.add(new Pair((Object)NOT_DEPLOYED_BEHAVIOR_DRAGGED, (Object)DEPLOYED_NODE_CONTAINER));
        for (String draggedElement : draggedElements) {
            for (String containerElement : containerElements) {
                if (draggedElement.equals(containerElement)) continue;
                boolean expected = true;
                for (Pair couple : expectedNotPossible) {
                    if (couple.getFirstValue() != draggedElement || couple.getSecondValue() != containerElement) continue;
                    expected = false;
                }
                DragAndDropPhysicalComponent.assertEquals((boolean)expected, (boolean)this.testDnDOnPAB(session, context, "[PAB] Physical System", draggedElement, containerElement));
            }
        }
    }

    public boolean testDnDOnPAB(Session session, SessionContext context, String diagramName, String draggedElement, String containerElement) throws Exception {
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, diagramName).run();
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA);
        try {
            diagram.dragAndDropComponent(draggedElement, containerElement);
        }
        catch (AssertionError e) {
            return false;
        }
        DSemanticDecorator draggedElementView = diagram.getView(draggedElement);
        DSemanticDecorator containerView = diagram.getView(containerElement);
        if (containerView instanceof DDiagramElementContainer) {
            DDiagramElementContainer dContainer = (DDiagramElementContainer)containerView;
            boolean result = dContainer.getElements().contains((Object)draggedElementView);
            this.undo(session, diagramContext);
            return result;
        }
        throw new Exception("DragAndDropPhysicalComponent: containerView is not a DDiagramElementContainer");
    }

    public void undo(Session session, DiagramContext diagramContext) {
        IEditorPart editorPart = DiagramHelper.getDiagramEditor((Session)session, (DDiagram)diagramContext.getDiagram());
        IActionBars actionBars = editorPart.getEditorSite().getActionBars();
        actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId()).run();
    }

    private boolean isNotDeployedNode(SessionContext context, String id) throws Exception {
        return this.getNature(context, id) == PhysicalComponentNature.NODE && !this.isDeployed(context, id) && !this.isActor(context, id);
    }

    private boolean isDeployedNode(SessionContext context, String id) throws Exception {
        return this.getNature(context, id) == PhysicalComponentNature.NODE && this.isDeployed(context, id) && !this.isActor(context, id);
    }

    private boolean isNotDeployedBehavior(SessionContext context, String id) throws Exception {
        return this.getNature(context, id) == PhysicalComponentNature.BEHAVIOR && !this.isDeployed(context, id) && !this.isActor(context, id);
    }

    private boolean isDeployedBehavior(SessionContext context, String id) throws Exception {
        return this.getNature(context, id) == PhysicalComponentNature.BEHAVIOR && this.isDeployed(context, id) && !this.isActor(context, id);
    }

    private PhysicalComponentNature getNature(SessionContext context, String id) throws Exception {
        Part part;
        AbstractType type;
        EObject element = context.getSemanticElement(id);
        if (element instanceof Part && (type = (part = (Part)element).getAbstractType()) instanceof PhysicalComponent) {
            PhysicalComponent component = (PhysicalComponent)type;
            return component.getNature();
        }
        throw new Exception("DragAndDropPhysicalComponent: semanticElement's abstractType is not a PhysicalComponent");
    }

    private boolean isDeployed(SessionContext context, String id) throws Exception {
        EObject element = context.getSemanticElement(id);
        if (element instanceof Part) {
            Part part = (Part)element;
            return PartExt.isDeployed((Part)part);
        }
        throw new Exception("DragAndDropPhysicalComponent: semanticElement is not a Part");
    }

    private boolean isActor(SessionContext context, String id) throws Exception {
        Part part;
        AbstractType type;
        EObject element = context.getSemanticElement(id);
        if (element instanceof Part && (type = (part = (Part)element).getAbstractType()) instanceof PhysicalComponent) {
            PhysicalComponent component = (PhysicalComponent)type;
            return ComponentExt.isActor((Component)component);
        }
        throw new Exception("DragAndDropPhysicalComponent: semanticElement's abstractType is not a PhysicalComponent");
    }

    @Override
    protected String getRequiredTestModel() {
        return "XABDiagrams";
    }
}

