/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.util.Arrays;
import org.eclipse.gef.EditPart;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.internal.metamodel.spec.DEdgeSpec;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.cache.PieIconCache;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class PhysicalLinkIconAndLabel
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        PABDiagram pab = PABDiagram.openDiagram((SessionContext)context, (String)"[PAB] Physical System");
        pab.clearDiagram();
        pab.createNodeComponent("Node 1", pab.getDiagramId());
        pab.createNodeComponent("Node 2", pab.getDiagramId());
        pab.createPhysicalLink("Node 1", "Node 2", "Physical Link 1");
        PhysicalPath path1 = pab.createPhysicalPath("Path 1", new String[]{"Physical Link 1"});
        PhysicalPath path2 = pab.createPhysicalPath("Path 2", new String[]{"Physical Link 1"});
        DDiagramElement plView = (DDiagramElement)pab.getView("Physical Link 1");
        PhysicalLinkIconAndLabel.assertTrue((boolean)(plView instanceof DEdgeSpec));
        this.checkIcons((XABDiagram)pab, plView);
        PhysicalLinkIconAndLabel.assertTrue((String)"Wrong label for overlapped Physical Link", (((DEdgeSpec)plView).getBeginLabel().equals(DiagramServices.getDiagramServices().getOverlappedLabels(Arrays.asList(path1.getName(), path2.getName()))) && ((DEdgeSpec)plView).getEndLabel().equals(DiagramServices.getDiagramServices().getOverlappedLabels(Arrays.asList(path1.getName(), path2.getName()))) ? 1 : 0) != 0);
    }

    private void checkIcons(XABDiagram diagram, DDiagramElement view) {
        Image expectedImage = PieIconCache.getInstance().getIcon(Arrays.asList(RGBValues.create((int)165, (int)42, (int)42), RGBValues.create((int)24, (int)114, (int)248)));
        PhysicalLinkIconAndLabel.assertTrue((String)"Problem while loading reference image", (expectedImage != null ? 1 : 0) != 0);
        EditPart edgeEditPart = DiagramServices.getDiagramServices().getEditPart(view);
        PhysicalLinkIconAndLabel.assertTrue((edgeEditPart != null ? 1 : 0) != 0);
        DEdgeBeginNameEditPart beginNameEditPart = (DEdgeBeginNameEditPart)edgeEditPart.getChildren().stream().filter(child -> child instanceof DEdgeBeginNameEditPart).findFirst().get();
        Image beginLabelIcon = beginNameEditPart.getLabelIcon();
        PhysicalLinkIconAndLabel.assertTrue((boolean)this.hasSameContent(expectedImage, beginLabelIcon));
        DEdgeEndNameEditPart endNameEditPart = (DEdgeEndNameEditPart)edgeEditPart.getChildren().stream().filter(child -> child instanceof DEdgeEndNameEditPart).findFirst().get();
        Image endLabelIcon = endNameEditPart.getLabelIcon();
        PhysicalLinkIconAndLabel.assertTrue((boolean)this.hasSameContent(expectedImage, endLabelIcon));
    }

    private boolean hasSameContent(Image image1, Image image2) {
        ImageData imageData1 = image1.getImageData();
        ImageData imageData2 = image2.getImageData();
        int i = 0;
        while (i < 256) {
            if (imageData1.data[i] != imageData2.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

