/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ReconnectComponentExchange
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXAB(context, "[OAB] Operational Context", BlockArchitectureExt.Type.OA, "ef3d73de-9cff-4893-bc98-9543077e9a4b", "6ce78848-33e3-4cde-96cf-0248225456e4", "2937d0b4-1d8b-4199-99e0-72605bfd87ca", "00583700-90af-48dc-be0a-dffca68ac815", "37ebde77-c992-4738-b737-43582104de1f", "4741aadb-47b5-4487-a717-7703577a3b06", "76e008c7-f343-4a7c-8ef9-6602cb3f4512");
        this.testOnXAB(context, "[SAB] System", BlockArchitectureExt.Type.SA, "73677d34-55e4-44cc-8c70-f266a83c36ef", "1976fbc0-8f98-41e3-9987-7893f631b739", "aa8324e2-b55a-4e3e-b28b-aef8d6ff0c4e", "fdb697c6-2c61-4717-8837-6ddc612f8f51", "2010abbe-589a-433f-90a2-594a978eb1a3", new String[0]);
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "6a2a8c14-a743-464e-9e5b-7cf9b39bdc56", "2c64e0ff-1d69-4348-acc7-ad8ee3d731a2", "0c756812-b0c7-4e81-b22f-ddda620e759e", "80df6258-ebfd-4cee-8771-1ac8a254fd1a", "23c30e2c-88a5-41a2-8410-8352dea321b2", new String[0]);
        this.testOnXAB(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "6dde609b-0f07-48fd-9c23-1f991a8f59d6", "7a718948-aa24-42ab-b057-80327eb1da43", "c682884c-7103-4751-ba15-3e1e847b6833", "c668b546-0d61-4ccc-ae08-d694406d1f2c", "6319edba-0886-46b6-8acb-80de02b0e9ba", new String[0]);
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String ceId, String oldSourceId, String newSourceId, String oldTargetId, String newTargetId, String ... invalidEnds) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.reconnectComponentExchange(ceId, oldSourceId, newSourceId, BlockArchitectureExt.LinkDirection.SOURCE);
        diagram.reconnectComponentExchange(ceId, oldTargetId, newTargetId, BlockArchitectureExt.LinkDirection.TARGET);
        if (type != BlockArchitectureExt.Type.OA) {
            diagram.cannotReconnectComponentExchange(ceId, newSourceId, oldTargetId, BlockArchitectureExt.LinkDirection.SOURCE);
            diagram.cannotReconnectComponentExchange(ceId, newTargetId, newSourceId, BlockArchitectureExt.LinkDirection.TARGET);
        }
        if (invalidEnds != null) {
            String[] stringArray = invalidEnds;
            int n = invalidEnds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                diagram.cannotReconnectComponentExchange(ceId, newSourceId, id, BlockArchitectureExt.LinkDirection.SOURCE);
                diagram.cannotReconnectComponentExchange(ceId, newTargetId, id, BlockArchitectureExt.LinkDirection.TARGET);
                ++n2;
            }
        }
    }
}

