/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class XDFBCreateFunctionalChain
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "Operational RA Data Flow Diagram", BlockArchitectureExt.Type.OA);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    protected void testOnXDFBDiagram(SessionContext context, String diagramName, BlockArchitectureExt.Type diagramType) {
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)diagramType);
        String diagramId = xdfb.getDiagramId();
        String function1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function3Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String functionalExchange1Id = xdfb.createEdge(function1Id, function2Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        String functionalExchange2Id = xdfb.createEdge(function2Id, function3Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        xdfb.createFunctionalChain(GenericModel.PATH_1, new String[]{functionalExchange1Id, functionalExchange2Id});
    }
}

