/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBInsertRemoveTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBTestCaseFunctions
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    private void testOnXDFBDiagram(SessionContext context, String diagramName, BlockArchitectureExt.Type diagramType) {
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)diagramType);
        String diagramId = xdfb.getDiagramId();
        String function1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function11Id = xdfb.createContainer(function1Id, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function22Id = xdfb.createContainer(function2Id, XDFBCreateContainerTools.CREATE_FUNCTION);
        String fe1Id = xdfb.createEdge(function11Id, function22Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        FunctionalExchange semanticExchange = (FunctionalExchange)xdfb.getSessionContext().getSemanticElement(fe1Id);
        String fop11Id = semanticExchange.getSource().getId();
        xdfb.hideElements(function1Id, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{function11Id});
        xdfb.hasView(fe1Id);
        xdfb.showElements(function1Id, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{function11Id});
        xdfb.hasView(fe1Id);
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{function1Id});
        xdfb.hasViews(new String[]{function11Id, fop11Id, fe1Id});
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{function11Id});
        xdfb.showElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{function1Id});
        xdfb.hasntView(function11Id);
    }
}

