/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xfbd;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionAllocator;
import org.polarsys.capella.core.sirius.analysis.constants.ColorNameConstants;
import org.polarsys.capella.test.diagram.common.ju.context.XBreakdownDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class XFBDBlueBold
extends EmptyProject {
    public void test() throws Exception {
        SessionContext context = new SessionContext(this.getSession(this.getRequiredTestModel()));
        for (BlockArchitectureExt.Type type : Arrays.asList(BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA)) {
            this.testNormalFunction(context, type);
            this.testActorFunction(context, type);
            this.testParentActorFunction(context, type);
        }
    }

    public void testNormalFunction(final SessionContext context, final BlockArchitectureExt.Type type) {
        context.getExecutionManager().execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                SkeletonHelper.createFunction((String)XFBDBlueBold.this.getRootFunctionId(type), (String)GenericModel.FUNCTION_1, (SessionContext)context);
            }
        });
        XBreakdownDiagram diagram = XBreakdownDiagram.createFBDiagram((SessionContext)context, (String)GenericModel.FUNCTION_1);
        this.isBold(diagram, GenericModel.FUNCTION_1);
        diagram.close();
    }

    public void testActorFunction(final SessionContext context, final BlockArchitectureExt.Type type) {
        context.getExecutionManager().execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                SkeletonHelper.createFunction((String)XFBDBlueBold.this.getRootFunctionId(type), (String)GenericModel.FUNCTION_2, (SessionContext)context);
                SkeletonHelper.createActor((String)XFBDBlueBold.this.getContextId(type), (String)GenericModel.ACTOR_1, (String)GenericModel.PART_1, (SessionContext)context);
                FunctionAllocator.allocate((Collection)context.getSemanticElements(new String[]{GenericModel.FUNCTION_2})).on((Component)context.getSemanticElement(GenericModel.ACTOR_1));
            }
        });
        XBreakdownDiagram diagram = XBreakdownDiagram.createFBDiagram((SessionContext)context, (String)GenericModel.FUNCTION_2);
        this.isBold(diagram, GenericModel.FUNCTION_2);
        if (type != BlockArchitectureExt.Type.OA) {
            this.isActorColor(diagram, GenericModel.FUNCTION_2);
        }
        diagram.close();
    }

    public void testParentActorFunction(final SessionContext context, final BlockArchitectureExt.Type type) {
        context.getExecutionManager().execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                SkeletonHelper.createFunction((String)XFBDBlueBold.this.getRootFunctionId(type), (String)GenericModel.FUNCTION_3, (SessionContext)context);
                SkeletonHelper.createFunction((String)GenericModel.FUNCTION_3, (String)GenericModel.FUNCTION_1_3, (SessionContext)context);
                SkeletonHelper.createActor((String)XFBDBlueBold.this.getContextId(type), (String)GenericModel.ACTOR_2, (String)GenericModel.PART_2, (SessionContext)context);
                FunctionAllocator.allocate((Collection)context.getSemanticElements(new String[]{GenericModel.FUNCTION_1_3})).on((Component)context.getSemanticElement(GenericModel.ACTOR_2));
            }
        });
        XBreakdownDiagram diagram = XBreakdownDiagram.createFBDiagram((SessionContext)context, (String)GenericModel.FUNCTION_3);
        this.isBold(diagram, GenericModel.FUNCTION_3);
        if (type != BlockArchitectureExt.Type.OA) {
            this.isActorColor(diagram, GenericModel.FUNCTION_3);
        }
        diagram.close();
    }

    private void isBold(XBreakdownDiagram diagram, String semanticId) {
        XFBDBlueBold.assertTrue((String)NLS.bind((String)"{0} shall be bold in breakdown diagram {0}", (Object)semanticId, (Object)diagram.getDiagram().getName()), (boolean)((DNode)diagram.getView(semanticId)).getOwnedStyle().getLabelFormat().contains((Object)FontFormat.BOLD_LITERAL));
    }

    private void isActorColor(XBreakdownDiagram diagram, String semanticId) {
        boolean result = ColorNameConstants.equals((RGBValues)((Square)((DNode)diagram.getView(semanticId)).getOwnedStyle()).getColor(), (String)"_CAP_Actor_Blue");
        XFBDBlueBold.assertTrue((String)NLS.bind((String)"{0} shall be blue in breakdown diagram {0}", (Object)semanticId, (Object)diagram.getDiagram().getName()), (boolean)result);
    }
}

