/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.massactions.ju.testcases.view.visualize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.command.GroupByColumnIndexCommand;
import org.polarsys.capella.test.massactions.ju.helpers.LayerHelper;
import org.polarsys.capella.test.massactions.ju.helpers.ViewHelper;
import org.polarsys.capella.test.massactions.ju.model.AbstractCapellaMATestCase;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.shared.view.MAView;
import org.polarsys.kitalpha.massactions.visualize.MVView;
import org.polarsys.kitalpha.massactions.visualize.table.layer.groupby.IMVGroupByLayer;

public class ColumnGroupByTest
extends AbstractCapellaMATestCase {
    @Override
    public void performTest() throws Exception {
        MVView visualizationView = ViewHelper.getActiveMVView();
        this.testGroupBy((MAView)visualizationView);
    }

    public void testGroupBy(MAView view) {
        int columnIndex;
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(this.getObject("3688cf59-97ee-4446-8041-7941cee6c767"));
        view.dataChanged(data);
        List<String> columnNamesToGroup = Arrays.asList("name", "visibleInDoc", "ordered", "unique");
        Collections.shuffle(columnNamesToGroup);
        IMVGroupByLayer groupByLayer = LayerHelper.extractGroupByLayer(view);
        IMAColumnPropertyAccessor columnPropertyAccessor = groupByLayer.getGridLayer().getBodyLayer().getColumnPropertyAccessor();
        GroupByHeaderLayer groupByHeaderLayer = groupByLayer.getGroupByHeaderLayer();
        GroupByModel groupByModel = groupByHeaderLayer.getGroupByModel();
        Collection<Object> beforeGroupedColumns = Collections.emptySet();
        Collection<Object> afterGroupedColumns = Collections.emptySet();
        for (String columnName : columnNamesToGroup) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            beforeGroupedColumns = new ArrayList(groupByModel.getGroupByColumnIndexes());
            ColumnGroupByTest.assertFalse((boolean)beforeGroupedColumns.contains(columnIndex));
            groupByHeaderLayer.doCommand((ILayerCommand)new GroupByColumnIndexCommand(columnIndex));
            afterGroupedColumns = new ArrayList(groupByModel.getGroupByColumnIndexes());
            ColumnGroupByTest.assertTrue((boolean)afterGroupedColumns.contains(columnIndex));
        }
        beforeGroupedColumns = new ArrayList(groupByModel.getGroupByColumnIndexes());
        data.add(this.getObject("3398fdbf-3415-4d03-a457-477324d2e091"));
        view.dataChanged(data);
        afterGroupedColumns = new ArrayList(groupByModel.getGroupByColumnIndexes());
        ColumnGroupByTest.assertFalse((boolean)beforeGroupedColumns.isEmpty());
        ColumnGroupByTest.assertFalse((boolean)afterGroupedColumns.isEmpty());
        ColumnGroupByTest.assertEquals(beforeGroupedColumns, afterGroupedColumns);
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        for (String columnName : columnNamesToGroup) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            afterGroupedColumns = new ArrayList(groupByModel.getGroupByColumnIndexes());
            ColumnGroupByTest.assertTrue((boolean)afterGroupedColumns.contains(columnIndex));
            System.err.println(columnName);
        }
        ViewHelper.resetViews(view);
        ColumnGroupByTest.assertTrue((boolean)data.remove(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1")));
        view.dataChanged(data);
        groupByLayer = LayerHelper.extractGroupByLayer(view);
        columnPropertyAccessor = groupByLayer.getGridLayer().getBodyLayer().getColumnPropertyAccessor();
        groupByHeaderLayer = groupByLayer.getGroupByHeaderLayer();
        groupByModel = groupByHeaderLayer.getGroupByModel();
        int columnIndex2 = columnPropertyAccessor.getColumnIndex("unique");
        beforeGroupedColumns = groupByModel.getGroupByColumnIndexes();
        ColumnGroupByTest.assertFalse((boolean)beforeGroupedColumns.contains(columnIndex2));
        groupByHeaderLayer.doCommand((ILayerCommand)new GroupByColumnIndexCommand(columnIndex2));
        afterGroupedColumns = groupByModel.getGroupByColumnIndexes();
        ColumnGroupByTest.assertTrue((boolean)afterGroupedColumns.contains(columnIndex2));
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        ColumnGroupByTest.assertEquals((int)-1, (int)columnPropertyAccessor.getColumnIndex("unique"));
        afterGroupedColumns = groupByModel.getGroupByColumnIndexes();
        ColumnGroupByTest.assertTrue((boolean)afterGroupedColumns.isEmpty());
        ViewHelper.resetViews(view);
    }
}

