/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.fwk;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.platform.sirius.ui.session.Messages;
import org.polarsys.capella.test.framework.helpers.log.StatusValidator;
import org.polarsys.capella.test.migration.ju.fwk.MigrationContributionTest;

public class EFactoryTest
extends MigrationContributionTest {
    static final String OWNER = "a";
    static final String ONE = "b";
    static final String TWO = "c";
    static final String EXT = "e";

    public void test() throws Exception {
        this.checkUncontributedNsUriChangedSamePrefixRaiseError();
        this.checkContributedNsUriChangedSamePrefix();
    }

    private MigrationContributionTest.Factory initModel(IFile file) {
        MigrationContributionTest.Factory f = new MigrationContributionTest.Factory(file);
        f.init(res -> {
            EObject owner = f.create("Owner", OWNER);
            EObject one = f.create("One", ONE);
            EObject extone = f.create("ExtOne", EXT);
            f.set(owner, "ownedOne", one);
            f.set(one, "ownedAbstracts", extone);
            res.getContents().add((Object)owner);
        });
        return f;
    }

    private void changeEPackageNsURI(MigrationContributionTest.Factory f) {
        f.execute(res -> {
            factory.set.getPackageRegistry().remove((Object)factory.PKG_EXT.getNsURI());
            factory.PKG_EXT.setNsURI("dummy");
            factory.set.getPackageRegistry().put((Object)factory.PKG_EXT.getNsURI(), (Object)factory.PKG_EXT);
        });
    }

    private void checkUncontributedNsUriChangedSamePrefixRaiseError() throws Exception {
        IFile file = this.getFile("test.capella");
        final MigrationContributionTest.Factory f = this.initModel(file);
        this.changeEPackageNsURI(f);
        this.addContribution(new MigrationContributionTest.TestMigrationContribution(this){

            public EFactory getEFactory(String prefix, Resource resource, MigrationContext context) {
                return super.getEFactory(prefix, resource, context);
            }

            public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
                super.contributePackageRegistry(packageRegistry, context);
                packageRegistry.put((Object)f.PKG.getNsURI(), (Object)f.PKG);
                packageRegistry.put((Object)f.PKG_EXT.getNsURI(), (Object)f.PKG_EXT);
            }
        });
        StatusValidator removeSomething = new StatusValidator(s -> s.getMessage().contains(Messages.CapellaSessionHelper_MissingExtensions_Message));
        Platform.addLogListener((ILogListener)removeSomething);
        this.launchMigration(file);
        Platform.removeLogListener((ILogListener)removeSomething);
        EFactoryTest.assertTrue((String)"Has reported error", (boolean)removeSomething.isValid());
    }

    private void checkContributedNsUriChangedSamePrefix() throws Exception {
        IFile file = this.getFile("test2.capella");
        final MigrationContributionTest.Factory f = this.initModel(file);
        this.changeEPackageNsURI(f);
        this.addContribution(new MigrationContributionTest.TestMigrationContribution(this){

            public EFactory getEFactory(String prefix, Resource resource, MigrationContext context) {
                if (prefix.equals("extension")) {
                    return f.PKG_EXT.getEFactoryInstance();
                }
                return super.getEFactory(prefix, resource, context);
            }

            public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
                super.contributePackageRegistry(packageRegistry, context);
                packageRegistry.put((Object)f.PKG.getNsURI(), (Object)f.PKG);
                packageRegistry.put((Object)f.PKG_EXT.getNsURI(), (Object)f.PKG_EXT);
            }
        });
        StatusValidator removeSomething = new StatusValidator(s -> s.getMessage().contains(Messages.CapellaSessionHelper_MissingExtensions_Message));
        Platform.addLogListener((ILogListener)removeSomething);
        this.launchMigration(file);
        Platform.removeLogListener((ILogListener)removeSomething);
        EFactoryTest.assertTrue((String)"Has reported error but it shall not", (!removeSomething.isValid() ? 1 : 0) != 0);
        f.test(res -> {
            EObject owner = res.getEObject(OWNER);
            EFactoryTest.assertTrue((owner != null ? 1 : 0) != 0);
        });
    }
}

