/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.crossreferencer;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerFactory;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateCtxArchiCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateEngSystemCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateLogicalArchiCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateOpAnalysisCmd;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.model.ju.crossreferencer.AbstractReflectiveCrossReferencerTest;

public class MoveElementToNewResourceTest
extends AbstractReflectiveCrossReferencerTest {
    private Project _capellaProject;
    private Resource _resource;
    private ExecutionManager _executionManager;

    public void testMoveElementToNewResource() {
        final LogicalArchitecture[] logicalArchitecture = new LogicalArchitecture[1];
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                CreateEngSystemCmd createEngSystemCmd = new CreateEngSystemCmd(MoveElementToNewResourceTest.this._capellaProject, "MoveElementTestProject");
                createEngSystemCmd.run();
                SystemEngineering systemEngineering = createEngSystemCmd.getSystemEngineering();
                CreateOpAnalysisCmd createOpAnalysisCmd = new CreateOpAnalysisCmd(systemEngineering, NamingConstants.SkeletonServicesImpl_package_name_operationalAnalysis);
                createOpAnalysisCmd.run();
                OperationalAnalysis operationalAnalysis = createOpAnalysisCmd.getOperationalAnalysis();
                OperationalActivity rootOperationalActivity = createOpAnalysisCmd.getRootOperationalActivity();
                CreateCtxArchiCmd createCtxArchiCmd = new CreateCtxArchiCmd(systemEngineering, NamingConstants.SkeletonServicesImpl_package_name_systemAnalysis, operationalAnalysis, rootOperationalActivity);
                createCtxArchiCmd.run();
                SystemAnalysis contextArchitecture = createCtxArchiCmd.getSystemAnalysis();
                SystemFunction systemFunction = createCtxArchiCmd.getSystemFunction();
                SystemComponent system = createCtxArchiCmd.getSystem();
                CreateLogicalArchiCmd createLogicalArchiCmd = new CreateLogicalArchiCmd(systemEngineering, NamingConstants.SkeletonServicesImpl_package_name_logicalArchitecture, contextArchitecture, systemFunction, system);
                createLogicalArchiCmd.run();
                logicalArchitecture[0] = createLogicalArchiCmd.getLogicalArchitecture();
            }
        };
        this.getExecutionManager().execute((ICommand)command);
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)this.getExecutionManager().getEditingDomain();
        SiriusCrossReferenceAdapter crossReferencer = editingDomain.getCrossReferencer();
        LogicalComponent logicalComponent = (LogicalComponent)logicalArchitecture[0].getSystem();
        MoveElementToNewResourceTest.assertTrue((boolean)logicalComponent.eAdapters().contains((Object)crossReferencer));
    }

    @Override
    protected void postRunTest() {
        super.postRunTest();
        ResourceSet resourceSet = this._resource.getResourceSet();
        this._resource.unload();
        resourceSet.getResources().remove((Object)this._resource);
        this._capellaProject = null;
        ExecutionManagerRegistry.getInstance().removeManager(this._executionManager);
        this._executionManager = null;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        IProject project = TestHelper.createCapellaProject((String)"MoveElementTestProject");
        String fullPath = String.valueOf(project.getFullPath().toString()) + "/moveElementTestProject." + "capella";
        URI capellaModelURI = URI.createPlatformResourceURI((String)fullPath, (boolean)true);
        this._resource = this.getExecutionManager().getEditingDomain().getResourceSet().createResource(capellaModelURI);
        this._capellaProject = CapellamodellerFactory.eINSTANCE.createProject("moveElementTestProject");
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                MoveElementToNewResourceTest.this._resource.getContents().add((Object)MoveElementToNewResourceTest.this._capellaProject);
            }
        };
        this.getExecutionManager().execute((ICommand)command);
    }

    @Override
    protected ExecutionManager getExecutionManager() {
        if (this._executionManager == null) {
            this._executionManager = ExecutionManagerRegistry.getInstance().addNewManager();
        }
        return this._executionManager;
    }

    @Override
    protected List<EClass> getRootTypes() {
        return null;
    }

    public void test() throws Exception {
        this.testMoveElementToNewResource();
    }
}

