/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.rename;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.core.sirius.ui.helper.ResourceHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;

public class RenameSpecialCharTestCase
extends BasicTestCase {
    public static final String TEST_MODEL_NAME = "[rename model]";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(TEST_MODEL_NAME);
    }

    public void test() throws Exception {
        List<RenameData> firstRenameData = Arrays.asList(new RenameData("[rename model].capella", "boringName1.capella"), new RenameData("[rename model].aird", "boringName2.aird"), new RenameData("[OA].airdfragment", "boringName3.airdfragment", "fragments"), new RenameData("[OA].capellafragment", "boringName4.capellafragment", "fragments"), new RenameData("[rename model].capella", "-!@^()[].capella"), new RenameData("[rename model].aird", "-!@^()[].aird"), new RenameData("[OA].airdfragment", "-!@^()[].airdfragment", "fragments"), new RenameData("[OA].capellafragment", "-!@^()[].capellafragment", "fragments"));
        for (RenameData renameData : firstRenameData) {
            IProject project = IResourceHelpers.getEclipseProjectInWorkspace((String)TEST_MODEL_NAME);
            IFile initialFile = this.getInitialFile(project, renameData);
            GuiActions.renameModelFile((IFile)initialFile, (String)renameData.renamedName);
            IFile renamedFile = this.getRenamedFile(project, renameData);
            this.assertRenamedFileExistence(renameData, renamedFile);
            this.assertValidSession(renamedFile);
            Collection allProjectFiles = ResourceHelper.collectFiles((IContainer)project);
            for (IFile childFile : allProjectFiles) {
                this.assertAllExpectedFilesRenamed(renameData, childFile);
                String childFileContent = FileHelper.readFile((String)childFile.getFullPath().toString());
                this.assertOldRawNameReferenceAbsence(renameData, initialFile, childFileContent);
                this.assertOldEncodedNameReferenceAbsence(renameData, initialFile, childFileContent);
            }
            GuiActions.renameModelFile((IFile)renamedFile, (String)renameData.initialName);
        }
    }

    private void assertOldEncodedNameReferenceAbsence(RenameData renameData, IFile initialFile, String fileContent) {
        String encodedName = URI.encodeSegment((String)renameData.initialName, (boolean)true);
        String fileContainsOldEncodedNameReferences = MessageFormat.format("File {0} should should not contain old encoded references towards {1}", initialFile.getName(), encodedName);
        RenameSpecialCharTestCase.assertFalse((String)fileContainsOldEncodedNameReferences, (boolean)fileContent.contains(encodedName));
    }

    private void assertOldRawNameReferenceAbsence(RenameData renameData, IFile initialFile, String fileContent) {
        String fileContainsOldRawNameReferences = MessageFormat.format("File {0} should should not contain old raw references towards {1}", initialFile.getName(), renameData.initialName);
        RenameSpecialCharTestCase.assertFalse((String)fileContainsOldRawNameReferences, (boolean)fileContent.contains(renameData.initialName));
    }

    private void assertAllExpectedFilesRenamed(RenameData renameData, IFile projectFile) {
        String fileNotRenamedMsg = MessageFormat.format("File {0} should have been renamed to {1}", projectFile.getName(), renameData.renamedName);
        RenameSpecialCharTestCase.assertFalse((String)fileNotRenamedMsg, (boolean)projectFile.getName().equals(renameData.initialName));
    }

    private void assertValidSession(IFile renamedFile) {
        IFile airdFile = this.getAirdFile(renamedFile);
        URI airdFileUri = EcoreUtil2.getURI((IFile)airdFile);
        Session session = SessionManager.INSTANCE.getSession(airdFileUri, (IProgressMonitor)new NullProgressMonitor());
        RenameSpecialCharTestCase.assertNotNull((String)MessageFormat.format("Invalid Session for renamed file {0}", renamedFile.getName()), (Object)session);
        GuiActions.closeSession((Session)session);
    }

    private void assertRenamedFileExistence(RenameData renameData, IFile renamedFile) {
        RenameSpecialCharTestCase.assertTrue((String)MessageFormat.format("File {0} should exist", renameData.renamedName), (boolean)renamedFile.exists());
    }

    private IFile getAirdFile(IFile renamedFile) {
        return "aird".equals(renamedFile.getFileExtension()) ? renamedFile : this.getAirdFileForLoadedModel(TEST_MODEL_NAME);
    }

    private IFile getInitialFile(IProject project, RenameData data) {
        return data.folder == null ? project.getFile(data.initialName) : project.getFolder(data.folder).getFile(data.initialName);
    }

    private IFile getRenamedFile(IProject project, RenameData data) {
        return data.folder == null ? project.getFile(data.renamedName) : project.getFolder(data.folder).getFile(data.renamedName);
    }

    private static class RenameData {
        protected final String initialName;
        protected final String renamedName;
        protected final String folder;

        public RenameData(String initialName, String renamedName, String folder) {
            this.folder = folder;
            this.initialName = initialName;
            this.renamedName = renamedName;
        }

        public RenameData(String initialName, String renamedName) {
            this(initialName, renamedName, null);
        }
    }
}

