/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcase.copyPasteModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.ModelQueryHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaCopyToClipboardCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaPasteCommand;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.transition.system.topdown.commands.TransitionCommandHelper;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class CopyPasteModelWithFunctionalAllocation
extends MiscModel {
    private IPropertyContext _propertiesContext = null;

    public void test() throws Exception {
        CapellaModel model = this.getTestModel();
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        final Project project = model.getProject(ted);
        String actor1Name = "Actor1";
        String activity1Name = "Activity1";
        final Entity[] actor1 = new Entity[1];
        ExecutionManager executionManager = TestHelper.getExecutionManager((EObject)project);
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                actor1[0] = OaFactory.eINSTANCE.createEntity("Actor1");
                actor1[0].setActor(true);
                ModelQueryHelper.getOperationalEntityPkg((Project)project).getOwnedEntities().add((Object)actor1[0]);
                CsServices.getService().createRepresentingPartIfNone((Component)actor1[0]);
                OperationalActivity activity1 = OaFactory.eINSTANCE.createOperationalActivity("Activity1");
                ModelQueryHelper.getRootOperationalActivity((Project)project).getOwnedFunctions().add((Object)activity1);
                FaServices.getFaServices().allocateToComponent((AbstractFunction)activity1, (Component)actor1[0]);
            }
        });
        this.setPreferenceValue("projection.functional", Boolean.TRUE);
        List<OperationalAnalysis> oa = Collections.singletonList(ModelQueryHelper.getOperationalAnalysis((Project)project));
        executionManager.execute(TransitionCommandHelper.getInstance().getOE2ActorTransitionCommand(oa, (IProgressMonitor)new NullProgressMonitor()));
        SystemComponent systemActor = (SystemComponent)EcoreUtil.getObjectByType(CopyPasteModelWithFunctionalAllocation.getSourceElements((EObject)actor1[0]), (EClassifier)CtxPackage.Literals.SYSTEM_COMPONENT);
        CapellaCommonNavigator capellaProjectView = (CapellaCommonNavigator)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("capella.project.explorer");
        CapellaCopyToClipboardCommand capellaCopyToClipboardCommand = new CapellaCopyToClipboardCommand((EditingDomain)ted, Collections.singleton(systemActor), (StructuredViewer)capellaProjectView.getCommonViewer());
        ted.getCommandStack().execute((Command)capellaCopyToClipboardCommand);
        ComponentPkg actorPkg = ModelQueryHelper.getSystemComponentPkg((Project)project);
        ArrayList contentBeforePaste = new ArrayList(actorPkg.eContents());
        CapellaPasteCommand capellaPasteCommand = new CapellaPasteCommand((EditingDomain)ted, (Object)actorPkg, null, -1);
        ted.getCommandStack().execute((Command)capellaPasteCommand);
        ArrayList addedElements = new ArrayList(actorPkg.eContents());
        addedElements.removeAll(contentBeforePaste);
        CopyPasteModelWithFunctionalAllocation.assertTrue((String)"2 additional elements (new Actor and its part) are expected in Actors package", (addedElements.size() == 2 ? 1 : 0) != 0);
        SystemComponent pastedActor = (SystemComponent)EcoreUtil.getObjectByType(addedElements, (EClassifier)CtxPackage.Literals.SYSTEM_COMPONENT);
        CopyPasteModelWithFunctionalAllocation.assertTrue((String)"Feature Owned Traces must be empty in copied Actor", (boolean)pastedActor.getOwnedTraces().isEmpty());
        CopyPasteModelWithFunctionalAllocation.assertTrue((String)"Feature Owned Functional Allocation must be empty in copied Actor", (boolean)pastedActor.getOwnedFunctionalAllocation().isEmpty());
        CopyPasteModelWithFunctionalAllocation.assertTrue((String)"There must be no unresolved proxies", (boolean)EcoreUtil.UnresolvedProxyCrossReferencer.find((EObject)project).isEmpty());
    }

    protected void setPreferenceValue(String id, Object value) {
        IProperty property;
        if (this._propertiesContext == null) {
            IProperties properties = new PropertiesLoader().getProperties("capella.core.transition.system.topdown.preferences");
            this._propertiesContext = new PropertyContext(properties);
        }
        if ((property = this._propertiesContext.getProperties().getProperty(id)) == null) {
            CopyPasteModelWithFunctionalAllocation.assertFalse((String)("Property not found : " + id), (boolean)true);
        }
        this._propertiesContext.setCurrentValue(property, value);
        this._propertiesContext.write(property);
    }

    public static Collection<EObject> getSourceElements(EObject object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (object instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)object).getIncomingTraces()) {
                result.add((EObject)trace.getSourceElement());
            }
        }
        return result;
    }
}

