/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcases.delete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.ui.toolkit.dialogs.ConfirmDeleteCapellaElementDialog;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public abstract class DeleteTest
extends MiscModel {
    IScope scope;

    protected void setUp() throws Exception {
        super.setUp();
        this.scope = new ScopeModelWrapper((IModel)this.getTestModel());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.scope = null;
    }

    void mustExist(String objectId) {
        this.mustExist(objectId, "element must not be deleted");
    }

    void mustExist(String objectId, String message) {
        EObject object = IdManager.getInstance().getEObject(objectId, this.scope);
        DeleteTest.assertTrue((String)message, (object != null ? 1 : 0) != 0);
    }

    void mustBeRemoved(String objectId) {
        this.mustBeRemoved(objectId, "element must be deleted");
    }

    void mustBeRemoved(String objectId, String message) {
        EObject object = IdManager.getInstance().getEObject(objectId, this.scope);
        DeleteTest.assertTrue((String)message, (object == null ? 1 : 0) != 0);
    }

    void removeElement(String objectId) {
        EObject object = IdManager.getInstance().getEObject(objectId, this.scope);
        CapellaDeleteCommand command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)object), Collections.singletonList(object), true, false, true);
        if (command.canExecute()) {
            command.execute();
        } else {
            DeleteTest.assertTrue((String)"cannot remove an element", (boolean)false);
        }
    }

    List<Object> getReferencingElements(String ... objectIds) {
        final ArrayList<Object> references = new ArrayList<Object>();
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        String[] stringArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            String objectId = stringArray[n2];
            EObject object = IdManager.getInstance().getEObject(objectId, this.scope);
            selectedElements.add(object);
            ++n2;
        }
        ConfirmDeleteCapellaElementDialog confirmDeletionDialog = new ConfirmDeleteCapellaElementDialog(selectedElements, true, selectedElements.toArray()){

            public void create() {
                Shell composite = new Shell();
                this.createElementsToDeleteViewer((Composite)composite);
                this.createReferencingElementViewer((Composite)composite);
                Object referencingInput = this.getReferencingElementsViewer().getInput();
                if (referencingInput instanceof TreeData) {
                    references.addAll(((TreeData)referencingInput).getValidElements());
                }
            }
        };
        confirmDeletionDialog.create();
        return references;
    }
}

