/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.helper;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class OdesignTestHelper {
    public static Viewpoint getViewpointByName(String vpName) {
        Optional<Viewpoint> vpOpt = ViewpointRegistry.getInstance().getViewpoints().stream().filter(vp -> vp.getName().equals(vpName)).findFirst();
        if (vpOpt.isPresent()) {
            return vpOpt.get();
        }
        return null;
    }

    public static DiagramDescription getDiagramDescriptionByName(Viewpoint vp, String desName) {
        List allDiagramDescriptions = vp.getOwnedRepresentations().stream().filter(DiagramDescription.class::isInstance).map(DiagramDescription.class::cast).collect(Collectors.toList());
        Optional<DiagramDescription> diagDesOpt = allDiagramDescriptions.stream().filter(des -> des.getName().equals(desName)).findFirst();
        if (diagDesOpt.isPresent()) {
            return diagDesOpt.get();
        }
        return null;
    }

    public static FilterDescription getFilterDescriptionByName(DiagramDescription diagDes, String filterName) {
        Optional<FilterDescription> filterOpt = diagDes.getFilters().stream().filter(f -> f.getName().equals(filterName)).findFirst();
        if (filterOpt.isPresent()) {
            return filterOpt.get();
        }
        return null;
    }

    public static boolean hasMapping(DiagramDescription diaDes, DiagramElementMapping mapping) {
        if (mapping instanceof ContainerMapping) {
            return ContentHelper.getAllContainerMappings((DiagramDescription)diaDes, (boolean)false).contains((Object)mapping);
        }
        if (mapping instanceof EdgeMapping) {
            return ContentHelper.getAllEdgeMappings((DiagramDescription)diaDes, (boolean)false).contains((Object)mapping);
        }
        return false;
    }

    public static boolean hasFilterOnMapping(DiagramDescription diagDes, String filterName, DiagramElementMapping mapping) {
        FilterDescription filter = OdesignTestHelper.getFilterDescriptionByName(diagDes, filterName);
        if (filter instanceof CompositeFilterDescription) {
            return ((CompositeFilterDescription)filter).getFilters().stream().filter(MappingFilter.class::isInstance).map(MappingFilter.class::cast).anyMatch(f -> f.getMappings().contains((Object)mapping));
        }
        return false;
    }

    public static boolean hasTool(DiagramDescription diaDes, String toolName) {
        EList tools = new DiagramComponentizationManager().getAllTools((Collection)ViewpointRegistry.getInstance().getViewpoints(), diaDes);
        return tools.stream().anyMatch(t -> t.getName() != null && t.getName().equals(toolName));
    }
}

