/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.identifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.PropertyResourceBundle;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.polarsys.capella.core.platform.sirius.ui.services.IElementIdentifierService;
import org.polarsys.capella.core.sirius.analysis.activator.SiriusViewActivator;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.odesign.identifier.IdentifierHelper;

public class ToolAndLabelCoherenceTest
extends BasicTestCase {
    private static final String PLUGIN_PROPERTIES = "plugin.properties";

    public void test() {
        PropertyResourceBundle pluginProperties = this.getPluginProperties();
        ArrayList errors = new ArrayList();
        IElementIdentifierService elementIdentifier = (IElementIdentifierService)PlatformUI.getWorkbench().getService(IElementIdentifierService.class);
        for (Viewpoint viewpoint : ViewpointSelection.getViewpoints((String)"capella")) {
            EList descriptions = viewpoint.getOwnedRepresentations();
            for (RepresentationDescription description : descriptions) {
                if (!(description instanceof DiagramDescription)) continue;
                DiagramDescription diagramDescription = (DiagramDescription)description;
                IdentifierHelper.getTools(diagramDescription).forEach(element -> {
                    String toolIdentifier = elementIdentifier.getIdentifier(diagramDescription, element);
                    String toolLabel = element.getLabel();
                    if (toolLabel == null) {
                        errors.add(NLS.bind((String)"Element {0} doesn't have a label.", (Object)element.getName()));
                    } else {
                        String[] tokens = toolLabel.split("%");
                        if (tokens.length != 2) {
                            errors.add(NLS.bind((String)"Element {0} is not internationalized.", (Object)element.getName()));
                        } else {
                            String label = tokens[1];
                            if (!this.isCommonTool((IdentifiedElement)element) && !label.equals(toolIdentifier)) {
                                errors.add(NLS.bind((String)"Element {0} doesn't use the correct label identifier. {1} instead of {2}", (Object[])new String[]{String.valueOf(viewpoint.getName()) + "::" + element.getLabel(), label, toolIdentifier}));
                            }
                            if (!pluginProperties.containsKey(label)) {
                                errors.add(NLS.bind((String)"Element {0} doesn't use a label identifier defined in the properties file {1}.", (Object[])new String[]{String.valueOf(viewpoint.getName()) + "::" + element.getLabel(), PLUGIN_PROPERTIES}));
                            }
                        }
                    }
                });
            }
        }
        if (!errors.isEmpty()) {
            ToolAndLabelCoherenceTest.assertTrue((String)errors.stream().collect(Collectors.joining("\n")), (boolean)errors.isEmpty());
        }
    }

    private boolean isCommonTool(IdentifiedElement element) {
        return Arrays.asList("hide.overlappedfunctional.chains.icon.filter", "hide.overlappedfunctional.chains.label.filter", "hide.overlappedphysical.paths.icon.filter", "hide.overlappedphysical.paths.label.filter", "hide.overlappedphysical.paths.label.filter", "hide.physical.paths.internal.links.filter", "hide.functional.chains.internal.links.filter").contains(element.getName());
    }

    private PropertyResourceBundle getPluginProperties() {
        PropertyResourceBundle propertyBundle = null;
        try {
            propertyBundle = new PropertyResourceBundle(FileLocator.openStream((Bundle)SiriusViewActivator.getInstance().getBundle(), (IPath)new Path(PLUGIN_PROPERTIES), (boolean)false));
        }
        catch (IOException e) {
            ToolAndLabelCoherenceTest.fail((String)NLS.bind((String)"Property file {0} doesn't exist.", (Object[])new String[]{PLUGIN_PROPERTIES}));
        }
        return propertyBundle;
    }
}

