/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.projection.scenario.fc2fs.FC2FSInitialization;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;

public class FC2FSInitializationTestCase
extends BasicTestCase {
    private static final String TEST_MODEL = "fc2fs";
    private static final String OP_ID = "9083a21d-3cf8-450d-bbaa-0091f19fce38";
    private static final String FC_ID = "dccc19a7-be7f-4aae-b29b-22ad966637dc";
    public static final String FUNCTIONALCHAIN_2 = "ec81f42a-b463-4902-b5c4-6b4797a04252";
    private static final String[] EXPECTED_OAS_INSTANCE_ROLES_ORDER = new String[]{"OA1", "OA2", "OA3", "OA4", "OA5"};
    private static final String[] EXPECTED_FS_INSTANCE_ROLES_ORDER = new String[]{"SF1", "SF2", "SF4", "SF5", "SF3"};

    public List<String> getRequiredTestModels() {
        return Arrays.asList(TEST_MODEL);
    }

    public void test() throws Exception {
        CapellaModel testModel = this.getTestModel(TEST_MODEL);
        this.doTest(testModel, OP_ID, 5, 5, 15, 15, 5, EXPECTED_OAS_INSTANCE_ROLES_ORDER);
        this.doTest(testModel, FC_ID, 5, 4, 12, 12, 4, EXPECTED_FS_INSTANCE_ROLES_ORDER);
        this.doTest(testModel, FUNCTIONALCHAIN_2, 6, 6, 18, 18, 6, null);
    }

    private void doTest(CapellaModel testModel, String funcChainID, int expectedNbOfInstRole, int expectedNbOfMsg, int excpectedNbOfEvents, int expectedNbOfInteractionFragments, int expectedNbOfTimeLapses, String[] expectedOrderOfInstRole) throws Exception {
        EObject object = EObjectHelper.getObject((IModel)testModel, (String)funcChainID);
        FC2FSInitializationTestCase.assertNotNull((Object)object);
        FC2FSInitializationTestCase.assertTrue((boolean)(object instanceof FunctionalChain));
        FunctionalChain fc = (FunctionalChain)object;
        FC2FSInitialization transformation = new FC2FSInitialization();
        transformation.execute(Arrays.asList(fc));
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)fc);
        FC2FSInitializationTestCase.assertNotNull((Object)architecture);
        AbstractCapabilityPkg abstractCapabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture);
        FC2FSInitializationTestCase.assertNotNull((Object)abstractCapabilityPkg);
        AbstractCapability abstractCapability = this.checkAbstractCapability(abstractCapabilityPkg);
        FC2FSInitializationTestCase.assertNotNull((Object)abstractCapability);
        Scenario scenario = this.checkScenario(abstractCapability);
        FC2FSInitializationTestCase.assertNotNull((Object)scenario);
        FC2FSInitializationTestCase.assertFalse((boolean)scenario.getOwnedInstanceRoles().isEmpty());
        FC2FSInitializationTestCase.assertTrue((scenario.getOwnedInstanceRoles().size() == expectedNbOfInstRole ? 1 : 0) != 0);
        if (expectedOrderOfInstRole != null) {
            FC2FSInitializationTestCase.assertTrue((boolean)Arrays.equals(expectedOrderOfInstRole, this.buildCurrentOrder((EList<InstanceRole>)scenario.getOwnedInstanceRoles())));
        }
        FC2FSInitializationTestCase.assertFalse((boolean)scenario.getOwnedMessages().isEmpty());
        FC2FSInitializationTestCase.assertTrue((scenario.getOwnedMessages().size() == expectedNbOfMsg ? 1 : 0) != 0);
        for (SequenceMessage msg : scenario.getOwnedMessages()) {
            MessageEnd sendingEnd = msg.getSendingEnd();
            FC2FSInitializationTestCase.assertNotNull((Object)sendingEnd);
            FC2FSInitializationTestCase.assertNotNull((Object)sendingEnd.getEvent());
            MessageEnd receivingEnd = msg.getReceivingEnd();
            FC2FSInitializationTestCase.assertNotNull((Object)receivingEnd);
            FC2FSInitializationTestCase.assertNotNull((Object)receivingEnd.getEvent());
        }
        FC2FSInitializationTestCase.assertEquals((int)excpectedNbOfEvents, (int)scenario.getOwnedEvents().size());
        FC2FSInitializationTestCase.assertEquals((int)expectedNbOfTimeLapses, (int)scenario.getOwnedTimeLapses().size());
        FC2FSInitializationTestCase.assertEquals((int)expectedNbOfInteractionFragments, (int)scenario.getOwnedInteractionFragments().size());
        FC2FSInitializationTestCase.assertFalse((boolean)scenario.getOwnedTraces().isEmpty());
        FC2FSInitializationTestCase.assertTrue((scenario.getOwnedTraces().size() == 1 ? 1 : 0) != 0);
        Trace trace = (Trace)scenario.getOwnedTraces().get(0);
        FC2FSInitializationTestCase.assertNotNull((Object)trace.getSourceElement());
        FC2FSInitializationTestCase.assertNotNull((Object)trace.getTargetElement());
    }

    private AbstractCapability checkAbstractCapability(AbstractCapabilityPkg abstractCapabilityPkg) throws Exception {
        if (abstractCapabilityPkg instanceof OperationalCapabilityPkg) {
            OperationalCapabilityPkg opCapaPkg = (OperationalCapabilityPkg)abstractCapabilityPkg;
            FC2FSInitializationTestCase.assertFalse((boolean)opCapaPkg.getOwnedOperationalCapabilities().isEmpty());
            FC2FSInitializationTestCase.assertTrue((opCapaPkg.getOwnedOperationalCapabilities().size() == 1 ? 1 : 0) != 0);
            return (AbstractCapability)opCapaPkg.getOwnedOperationalCapabilities().get(0);
        }
        if (abstractCapabilityPkg instanceof CapabilityPkg) {
            CapabilityPkg capabilityPkg = (CapabilityPkg)abstractCapabilityPkg;
            FC2FSInitializationTestCase.assertFalse((boolean)capabilityPkg.getOwnedCapabilities().isEmpty());
            FC2FSInitializationTestCase.assertTrue((capabilityPkg.getOwnedCapabilities().size() == 1 ? 1 : 0) != 0);
            return (AbstractCapability)capabilityPkg.getOwnedCapabilities().get(0);
        }
        return null;
    }

    private Scenario checkScenario(AbstractCapability abstractCapability) {
        if (abstractCapability instanceof OperationalCapability) {
            OperationalCapability opCapa = (OperationalCapability)abstractCapability;
            FC2FSInitializationTestCase.assertFalse((boolean)opCapa.getOwnedScenarios().isEmpty());
            FC2FSInitializationTestCase.assertTrue((opCapa.getOwnedScenarios().size() == 1 ? 1 : 0) != 0);
            return (Scenario)opCapa.getOwnedScenarios().get(0);
        }
        if (abstractCapability instanceof Capability) {
            Capability capability = (Capability)abstractCapability;
            FC2FSInitializationTestCase.assertFalse((boolean)capability.getOwnedScenarios().isEmpty());
            return (Scenario)capability.getOwnedScenarios().get(capability.getOwnedScenarios().size() - 1);
        }
        return null;
    }

    private String[] buildCurrentOrder(EList<InstanceRole> instanceRoles) {
        ArrayList<String> result = new ArrayList<String>();
        for (InstanceRole instRole : instanceRoles) {
            result.add(instRole.getName());
        }
        return result.toArray(new String[0]);
    }
}

