/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.transition.system.topdown.commands.TransitionCommandHelper;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;

public class LogicalActorTransition
extends TopDownTransitionTestCase {
    public static final String LA_2 = "0500ac88-7e78-4a9b-a1e3-91ab6e9d86ad";
    public static final String LOGICAL_FUNCTION_1 = "1fcba955-aa85-46e0-bfa5-ff0f525bafee";
    public static final String LC_1 = "10ead931-83d8-473d-8446-57516b037c93";
    public static final String LA_1 = "d233a040-94d0-4c84-8fa3-1568e298c4b4";
    public static final String LA_A = "0500ac88-7e78-4a9b-a1e3-91ab6e9d86ad";
    public static final String LA_B = "9c1dadc3-9a75-40ca-b32f-da6550db2f86";
    public static final String LA_C = "594b89a8-cd03-4cbc-bb80-6b874293781e";
    public static final String LA_D = "ee818e8a-7fe6-47aa-ab6a-13c0a404dd13";
    public static final String LA_E = "6a40ba49-bb00-4d88-bbd9-ffa4aeef98ae";
    public static final String LA_F = "1134db1a-6eb6-4cfb-a088-b7097eb7345c";
    public static final String LCP_1 = "eb48fe97-d64f-4d49-976a-cb24b55adc01";
    public static final String LCP_2 = "83ef3f20-47b4-4b8c-9888-ef01ce16f6ee";
    public static final String LCP_3 = "f113bb9b-b1d0-4f56-9b03-513b529b0975";
    public static final String LC_A = "5bb813b3-44b2-4001-84df-f4f35cc86a3e";
    public static final String LOGICAL_ARCHITECTURE = "1b0dca52-e1e6-4a89-bce0-2324e057fa36";
    public static final String LOGICAL_SYSTEM = "7949e1d0-760e-4aa9-b322-0d77042c0ec5";
    public static final String STRUCTURE = "44dd3437-48c1-4fd2-8a6e-34164577bd7a";

    public void performTest() throws Exception {
        this.performActorTransition(this.getObjects(new String[]{"0500ac88-7e78-4a9b-a1e3-91ab6e9d86ad"}));
        EObject PC = this.mustBeTransitionedTo("0500ac88-7e78-4a9b-a1e3-91ab6e9d86ad", PaPackage.Literals.PHYSICAL_COMPONENT);
        EObject PF = this.mustBeTransitionedTo(LOGICAL_FUNCTION_1, PaPackage.Literals.PHYSICAL_FUNCTION);
        LogicalActorTransition.assertTrue((boolean)((PhysicalComponent)PC).getAllocatedFunctions().contains((Object)PF));
        ComponentPkg componentPkg = (ComponentPkg)this.getObject(STRUCTURE);
        List actors = ComponentPkgExt.getExternalActors((ComponentPkg)componentPkg);
        LogicalActorTransition.assertTrue((boolean)actors.stream().map(ModelElement::getId).collect(Collectors.toList()).containsAll(Arrays.asList("0500ac88-7e78-4a9b-a1e3-91ab6e9d86ad", LA_B, LA_C, LA_D, LA_E, LA_F)));
        LogicalActorTransition.assertEquals((int)actors.size(), (int)6);
        this.performActorTransition(actors);
        this.shouldNotBeTransitioned(LC_1, PaPackage.Literals.PHYSICAL_COMPONENT);
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LOGICAL_ARCHITECTURE)));
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture / Structure", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(STRUCTURE)));
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture / Structure / Logical Component Package", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LCP_2)));
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture / Structure / Logical Component Package / LA E", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LA_E)));
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture / Structure / Actor", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject("0500ac88-7e78-4a9b-a1e3-91ab6e9d86ad")));
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture / Structure / Actor / Actor", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LA_B)));
        LogicalActorTransition.assertTrue((String)"Possible to perform actor transition on : Logical Architecture / Structure / Actor / Actor / Actor", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LA_C)));
        LogicalActorTransition.assertFalse((String)"Not possible to perform actor transition on : Logical Architecture / Logical System", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LOGICAL_SYSTEM)));
        LogicalActorTransition.assertFalse((String)"Not possible to perform actor transition on : Logical Architecture / Logical System / Logical Component", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LC_1)));
        LogicalActorTransition.assertFalse((String)"Not possible to perform actor transition on : Logical Architecture / Logical System / Actor", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LA_1)));
        LogicalActorTransition.assertFalse((String)"Not possible to perform actor transition on : Logical Architecture / Logical System / Logical Component Package", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LCP_1)));
        LogicalActorTransition.assertFalse((String)"Not possible to perform actor transition on external Logical Component Package without any actor under it", (boolean)TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(LCP_3)));
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("Transition");
    }
}

