/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.oa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelOaSa;

public class MissionTransition
extends TopDownTransitionTestCase {
    private OperationalCapabilityPkg _rootOCPkg;
    private OperationalCapabilityPkg _subOCPkg;
    private OperationalCapability _oaOC1;
    private OperationalCapability _oaOC11;
    private OperationalCapability _oaOC2;
    private OperationalCapability _oaOC3;
    private OperationalCapability _oaSubOC1;
    private OperationalCapability _oaSubOC2;
    private MissionPkg _rootMissionPkg;
    private MissionPkg _subMissionPkg;
    private Mission _ctxOC1;
    private Mission _ctxOC11;
    private Mission _ctxOC2;
    private Mission _ctxOC3;
    private Mission _ctxSubOC1;
    private Mission _ctxSubOC2;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._rootOCPkg = (OperationalCapabilityPkg)this.getObject(ModelOaSa.rootOCPkgId);
        this._oaOC1 = (OperationalCapability)this.getObject(ModelOaSa.oc1Id);
        this._oaOC11 = (OperationalCapability)this.getObject(ModelOaSa.oc11Id);
        this._oaOC2 = (OperationalCapability)this.getObject(ModelOaSa.oc2Id);
        this._rootMissionPkg = (MissionPkg)this.getObject(ModelOaSa.rootMissionPkgId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performOCtoSMTransition(Collections.singletonList(this._oaOC11));
        this._ctxOC11 = (Mission)this._rootMissionPkg.getOwnedMissions().get(0);
        this.mustNotBeNull((EObject)this._ctxOC11);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC11.getName(), (Object)this._oaOC11.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC11) == this._oaOC11 ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performOCtoSMTransition(Collections.singletonList(this._rootOCPkg));
        this._ctxOC1 = ProjectionTestUtils.getProjectedMission(this._oaOC1);
        this.mustNotBeNull((EObject)this._ctxOC1);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC1.getName()), (this._ctxOC1.eContainer() == this._rootMissionPkg ? 1 : 0) != 0);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC1.getName(), (Object)this._oaOC1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC1) == this._oaOC1 ? 1 : 0) != 0);
        this._ctxOC2 = ProjectionTestUtils.getProjectedMission(this._oaOC2);
        this.mustNotBeNull((EObject)this._ctxOC2);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC2.getName()), (this._ctxOC2.eContainer() == this._rootMissionPkg ? 1 : 0) != 0);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC2.getName(), (Object)this._oaOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC2) == this._oaOC2 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performOCtoSMTransition(Collections.singletonList(this._rootOCPkg));
        int oaSize = this._rootOCPkg.getOwnedOperationalCapabilities().size();
        int ctxSize = this._rootMissionPkg.getOwnedMissions().size();
        MissionTransition.assertTrue((String)Messages.WrongAllocation, (oaSize == ctxSize ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.getExecutionManager((EObject)this._rootOCPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                MissionTransition.this._subOCPkg = OaFactory.eINSTANCE.createOperationalCapabilityPkg("Sub OC Pkg");
                MissionTransition.this._rootOCPkg.getOwnedOperationalCapabilityPkgs().add((Object)MissionTransition.this._subOCPkg);
                MissionTransition.this._oaSubOC1 = OaFactory.eINSTANCE.createOperationalCapability("Sub OC1");
                MissionTransition.this._subOCPkg.getOwnedOperationalCapabilities().add((Object)MissionTransition.this._oaSubOC1);
            }
        });
        this.performOCtoSMTransition(Collections.singletonList(this._oaSubOC1));
        this._subMissionPkg = (MissionPkg)this._rootMissionPkg.getOwnedMissionPkgs().get(0);
        this.mustNotBeNull((EObject)this._subMissionPkg);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._subMissionPkg.getName(), (Object)this._subOCPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._subMissionPkg) == this._subOCPkg ? 1 : 0) != 0);
        this._ctxSubOC1 = (Mission)this._subMissionPkg.getOwnedMissions().get(0);
        this.mustNotBeNull((EObject)this._ctxSubOC1);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxSubOC1.getName(), (Object)this._oaSubOC1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxSubOC1) == this._oaSubOC1 ? 1 : 0) != 0);
    }

    public void performTest5() throws Exception {
        this.getExecutionManager((EObject)this._rootOCPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                MissionTransition.this._oaOC2.destroy();
                MissionTransition.this._oaOC3 = OaFactory.eINSTANCE.createOperationalCapability("OC3");
                MissionTransition.this._rootOCPkg.getOwnedOperationalCapabilities().add((Object)MissionTransition.this._oaOC3);
                MissionTransition.this._oaSubOC2 = OaFactory.eINSTANCE.createOperationalCapability("Sub OC2");
                MissionTransition.this._subOCPkg.getOwnedOperationalCapabilities().add((Object)MissionTransition.this._oaSubOC2);
            }
        });
        this.performOCtoSMTransition(Collections.singletonList(this._rootOCPkg));
        this.mustNotBeNull((EObject)this._ctxOC2);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC2.getName(), (Object)this._oaOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC2) == null ? 1 : 0) != 0);
        this._ctxOC3 = ProjectionTestUtils.getProjectedMission(this._oaOC3);
        this.mustNotBeNull((EObject)this._ctxOC3);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.WrongParent, (Object)this._ctxOC3.getName()), (this._ctxOC3.eContainer() == this._rootMissionPkg ? 1 : 0) != 0);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxOC3.getName(), (Object)this._oaOC3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxOC3) == this._oaOC3 ? 1 : 0) != 0);
        this._subMissionPkg = (MissionPkg)this._rootMissionPkg.getOwnedMissionPkgs().get(0);
        this.mustNotBeNull((EObject)this._subMissionPkg);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._subMissionPkg.getName(), (Object)this._subOCPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._subMissionPkg) == this._subOCPkg ? 1 : 0) != 0);
        this._ctxSubOC2 = ProjectionTestUtils.getProjectedMission(this._oaSubOC2);
        this.mustNotBeNull((EObject)this._ctxSubOC2);
        MissionTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._ctxSubOC2.getName(), (Object)this._oaSubOC2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._ctxSubOC2) == this._oaSubOC2 ? 1 : 0) != 0);
    }
}

