/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.platform.sirius.ted.DataNotifier;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.OracleDefinition;
import org.polarsys.capella.test.validation.rules.ju.testcases.ValidationRulePartialTestCase;

public class Rule_I_45
extends ValidationRulePartialTestCase {
    public static final String VALID_EXCHANGE_ITEM_1 = "4f7a6106-ee35-4dc0-87e2-74b67f2b5aae";
    public static final String VALID_EXCHANGE_ITEM_INSTANCE_1 = "a31d4905-1834-4546-95a0-25ea02f4319d";
    public static final String VALID_EXCHANGE_ITEM_INSTANCE_2 = "d6647703-10c2-4abf-9e69-ce45fa12b7f3";
    public static final String INVALID_EXCHANGE_ITEM = "d6c9f791-0287-4be8-ae7a-31c4af18de84";
    public static final String VALID_LC1_PART = "7ba0c519-1570-4d6a-b38a-e04afc30a622";
    public static final String INVALID_LC2_PART = "44394260-1494-487b-94f1-659ace72ab84";

    @Override
    protected List<String> getScopeDefinition() {
        return Arrays.asList(VALID_EXCHANGE_ITEM_1, VALID_EXCHANGE_ITEM_INSTANCE_1, VALID_EXCHANGE_ITEM_INSTANCE_2, VALID_EXCHANGE_ITEM_INSTANCE_2, INVALID_EXCHANGE_ITEM, VALID_LC1_PART, INVALID_LC2_PART);
    }

    @Override
    protected EClass getTargetedEClass() {
        return ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT;
    }

    @Override
    protected String getRuleID() {
        return "org.polarsys.capella.core.data.core.validation.I_45";
    }

    @Override
    protected List<OracleDefinition> getOracleDefinitions() {
        return Arrays.asList(new OracleDefinition(VALID_EXCHANGE_ITEM_1, 0), new OracleDefinition(VALID_EXCHANGE_ITEM_INSTANCE_1, 0), new OracleDefinition(VALID_EXCHANGE_ITEM_INSTANCE_2, 0), new OracleDefinition(INVALID_EXCHANGE_ITEM, 1), new OracleDefinition(VALID_LC1_PART, 0), new OracleDefinition(INVALID_LC2_PART, 1));
    }

    @Override
    public void test() throws Exception {
        this.prepareI45();
        super.test();
    }

    private void prepareI45() {
        CapellaModel model = this.getTestModel(this.getRequiredTestModel());
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        final Part part = (Part)IdManager.getInstance().getEObject(INVALID_LC2_PART, (IScope)scope);
        part.eResource().eAdapters().removeIf(DataNotifier.class::isInstance);
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)model.getEditingDomain());
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                part.setName("differentName");
            }
        });
    }

    @Override
    protected String getRequiredTestModel() {
        return "exchange-item-instance-and-part-model";
    }
}

