/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.util.StatusLabelHelper;
import org.polarsys.capella.common.ui.services.swt.events.AbstractKeyAdapter;

public class TextRenderer
extends AbstractRenderer {
    protected Composite rootTextControl;
    protected Composite rootControl;
    protected Text textControl;
    protected Label imageControl;
    protected Label validateControl;
    Label label;
    Color errorColor;
    Color warningColor;
    Color defaultColor;
    Color disabledColor;

    public Label createPartLabel(Composite parent, String text, boolean required) {
        this.label = new Label(parent, 0);
        this.label.setText(text);
        if (required) {
            this.label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        return this.label;
    }

    protected Color getDefaultColor(Display display) {
        return display.getSystemColor(1);
    }

    @Override
    public void performRender(Composite parent, IRendererContext context) {
        GridLayout layout;
        GridData data;
        Display display = parent.getShell().getDisplay();
        if (this.isColoredOnValidation()) {
            this.errorColor = this.defaultColor = this.getDefaultColor(display);
            this.warningColor = this.defaultColor;
            this.disabledColor = this.defaultColor;
        }
        if (this.isDescription() && !Boolean.FALSE.equals(context.getParameter("PARAMETER_RENDER_LABEL"))) {
            this.createPartLabel(parent, String.valueOf(context.getProperty(this).getName()) + ':', false);
        }
        this.rootControl = new Composite(parent, 0);
        this.rootTextControl = new Composite(this.rootControl, this.getRootStyle()){

            public void setBackground(Color color) {
                if (color != null && !color.equals((Object)this.getShell().getDisplay().getSystemColor(22))) {
                    super.setBackground(color);
                }
            }
        };
        if (parent.getLayout() instanceof GridLayout) {
            data = new GridData(768);
            layout = new GridLayout();
            layout.numColumns = this.getNbColumn();
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.rootControl.setLayoutData((Object)data);
            this.rootControl.setLayout((Layout)layout);
        } else {
            this.rootControl.setLayout((Layout)new FillLayout(256));
        }
        if (parent.getLayout() instanceof GridLayout) {
            data = new GridData(768);
            layout = new GridLayout();
            layout.numColumns = this.getNbTextColumn();
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = 4;
            layout.marginHeight = 2;
            this.rootTextControl.setLayoutData((Object)data);
            this.rootTextControl.setLayout((Layout)layout);
        } else {
            this.rootTextControl.setLayout((Layout)new FillLayout(256));
        }
        this.initializeControls(this.rootControl, context);
    }

    protected int getRootStyle() {
        return 2048;
    }

    protected boolean isValidationEnd() {
        return true;
    }

    protected void initializeControls(Composite parent, final IRendererContext context) {
        if (this.isImage()) {
            this.imageControl = this.createImageControl(this.rootTextControl);
        }
        if (!this.isValidationEnd()) {
            this.validateControl = this.createImageControl(this.rootTextControl);
        }
        this.textControl = this.createTextControl(this.rootTextControl);
        if (parent.getLayout() instanceof GridLayout) {
            this.textControl.setLayoutData((Object)new GridData(768));
        }
        this.textControl.addKeyListener((KeyListener)new AbstractKeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r' && this.handle(event, "CR")) {
                    TextRenderer.this.handleCRKeyStoke(context);
                }
            }
        });
        this.textControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                TextRenderer.this.textControl.forceFocus();
                if (TextRenderer.this.isDisposed()) {
                    return;
                }
                if (TextRenderer.this.isEditable(context.getProperty(TextRenderer.this), context)) {
                    TextRenderer.this.textControl.setText(TextRenderer.this.getEditableText(context));
                }
            }

            public void focusLost(FocusEvent event) {
                if (TextRenderer.this.isDisposed()) {
                    return;
                }
                TextRenderer.this.textChanged(context);
            }
        });
        if (this.isValidationEnd()) {
            this.validateControl = this.createImageControl(this.rootTextControl);
        }
        StatusLabelHelper.updateImage(Status.OK_STATUS, this.validateControl);
    }

    protected void handleCRKeyStoke(IRendererContext context) {
        this.textChanged(context);
    }

    protected void textChanged(IRendererContext context) {
        String newValue;
        IProperty property = context.getProperty(this);
        if (this.isEditable(property, context) && !(newValue = this.textControl.getText()).equals(context.getPropertyContext().getCurrentValue(property))) {
            this.changeValue(property, context, newValue);
            this.updatedValue(property, context, newValue);
        }
    }

    protected boolean isImage() {
        return false;
    }

    protected boolean isDescription() {
        return true;
    }

    protected int getNbColumn() {
        return 1;
    }

    protected int getNbTextColumn() {
        return 1 + (this.isImage() ? 1 : 0) + 1;
    }

    protected String getEditableText(IRendererContext context) {
        return this.textControl.getText();
    }

    private Label createImageControl(Composite parent) {
        return new Label(parent, 0);
    }

    protected Text createTextControl(Composite parent) {
        return new Text(parent, 0);
    }

    @Override
    public void initialize(IProperty property, IRendererContext context) {
        this.setBackgroundTextControl(this.defaultColor);
        Object value = context.getPropertyContext().getDefaultValue(property);
        this.updatedValue(property, context, value);
    }

    protected boolean isEditable(IProperty property, IRendererContext context) {
        return property instanceof IEditableProperty && property.isEnabled(context.getPropertyContext());
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext rendererContext, Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        if (property.equals(rendererContext.getProperty(this))) {
            Image image;
            Object value = property.toType(newValue, rendererContext.getPropertyContext());
            IStatus diag = property.validate(value, rendererContext.getPropertyContext());
            StatusLabelHelper.updateTooltip(diag, this.validateControl, true);
            String text = this.getLabelProvider(rendererContext).getText(value);
            if (this.isImage() && !this.imageControl.isDisposed() && (image = this.getLabelProvider(rendererContext).getImage(value)) != null && !image.equals((Object)this.imageControl.getImage())) {
                this.imageControl.setImage(image);
            }
            if (text == null) {
                text = "";
            }
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setEnabled(property.isEnabled(rendererContext.getPropertyContext()));
            }
            if (!this.textControl.isDisposed()) {
                this.textControl.setEditable(this.isEditable(property, rendererContext));
                this.textControl.setText(text);
                if (this.isColoredOnValidation()) {
                    StatusLabelHelper.updateImage(diag, this.validateControl);
                    if (diag != null) {
                        if (diag.isOK()) {
                            if (!this.defaultColor.equals((Object)this.rootTextControl.getBackground())) {
                                this.setBackgroundTextControl(this.defaultColor);
                            }
                            if (!this.isEditable(property, rendererContext) && !this.disabledColor.equals((Object)this.rootTextControl.getBackground())) {
                                this.setBackgroundTextControl(this.disabledColor);
                            }
                        } else if (diag.matches(1)) {
                            if (!this.defaultColor.equals((Object)this.rootTextControl.getBackground())) {
                                this.setBackgroundTextControl(this.defaultColor);
                            }
                        } else if (diag.matches(2)) {
                            if (!this.warningColor.equals((Object)this.rootTextControl.getBackground())) {
                                this.setBackgroundTextControl(this.warningColor);
                            }
                        } else if (diag.matches(4) && !this.errorColor.equals((Object)this.rootTextControl.getBackground())) {
                            this.setBackgroundTextControl(this.errorColor);
                        }
                    }
                }
            }
        }
    }

    protected void setBackgroundTextControl(Color color) {
        this.textControl.setBackground(color);
        this.rootTextControl.setBackground(color);
        this.validateControl.setBackground(color);
        if (this.isImage()) {
            this.imageControl.setBackground(color);
        }
    }

    protected boolean isColoredOnValidation() {
        return true;
    }

    @Override
    public void dispose(IRendererContext context) {
        super.dispose(context);
        if (this.textControl != null) {
            this.textControl.dispose();
        }
        if (this.imageControl != null) {
            this.imageControl.dispose();
        }
        if (this.defaultColor != null) {
            this.defaultColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
        if (this.warningColor != null) {
            this.warningColor.dispose();
        }
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
    }
}

