/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.services;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public abstract class AbstractUIActivator
extends AbstractUIPlugin {
    private static final String ICONS_PATH = "icons/";

    public ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = this.createImageDescriptor(key);
            imageRegistry.put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.createImageDescriptor(key);
            imageRegistry.put(key, imageDescriptor);
            image = imageRegistry.get(key);
        }
        return image;
    }

    protected ImageDescriptor createImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getPluginId(), (String)(ICONS_PATH + key));
        return imageDescriptor;
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public void log(int severity, String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(severity, this.getPluginId(), message, exception));
    }

    public URL getImageURL(String key) {
        Bundle bundle = Platform.getBundle((String)this.getPluginId());
        if (!BundleUtility.isReady((Bundle)bundle)) {
            return null;
        }
        return BundleUtility.find((Bundle)bundle, (String)(ICONS_PATH + key));
    }
}

