/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.benchmarks.ju.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class MemoryLogger {
    private static MemoryLogger singleton;
    protected Map<String, Long> usedMemoryInfo = new HashMap<String, Long>();

    public static MemoryLogger getInstance() {
        if (singleton == null) {
            singleton = new MemoryLogger();
        }
        return singleton;
    }

    private MemoryLogger() {
    }

    public void log(String testCaseName, Long usedMemory) {
        this.usedMemoryInfo.put(testCaseName, usedMemory);
    }

    public void clear() {
        this.usedMemoryInfo.clear();
    }

    public void saveToFile(String fileNamePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(MemoryLogger.getMemoryFile(fileNamePath), true), "utf-8"));){
                for (Map.Entry<String, Long> entry : this.usedMemoryInfo.entrySet()) {
                    String testName = entry.getKey();
                    Long memoryValue = entry.getValue();
                    writer.write(String.valueOf(testName) + "," + memoryValue + " MB \n");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static File getMemoryFile(String fileNamePath) {
        File memoryFile = new File(fileNamePath);
        if (!memoryFile.getParentFile().exists()) {
            memoryFile.getParentFile().mkdirs();
        }
        if (!memoryFile.exists()) {
            try {
                memoryFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return memoryFile;
    }
}

