/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.SetUnsynchronizedStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class MSMDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public MSMDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static void setSynchronized(MSMDiagram diagram) {
        new SetUnsynchronizedStep(diagram, true).run();
    }

    public static void setUnsynchronized(MSMDiagram diagram) {
        new SetUnsynchronizedStep(diagram).run();
    }

    public static MSMDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = "Mode State Machine";
        return (MSMDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new MSMDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static MSMDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (MSMDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new MSMDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public void createMode(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "mode", idContainer, id).run();
    }

    public void cannotCreateMode(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "mode", idContainer, id).cannotRun();
    }

    public void cannotCreateState(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "state", idContainer, id).cannotRun();
    }

    public void createState(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "state", idContainer, id).run();
    }

    public void createRegion(String idContainer, String id) {
        new CreateContainerTool((DiagramContext)this, "region", idContainer, id).run();
    }

    public void createChoice(String containerId) {
        this.createNodeElement(containerId, "choice");
    }

    public void createFinal(String containerId) {
        this.createNodeElement(containerId, "final");
    }

    public void createFork(String containerId) {
        this.createNodeElement(containerId, "fork");
    }

    public void createInitial(String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "initial", idContainer, id).run();
    }

    public void createJoin(String containerId) {
        this.createNodeElement(containerId, "join");
    }

    public void createTerminate(String containerId) {
        this.createNodeElement(containerId, "terminate");
    }

    public void createDeepHistory(String containerId) {
        this.createNodeElement(containerId, "deep.history");
    }

    public void createShallowHistory(String containerId) {
        this.createNodeElement(containerId, "shallow.history");
    }

    public void createEntryPoint(String idTargetContainer, String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "entry.point", idTargetContainer, idContainer, id).run();
    }

    public void createExitPoint(String idTargetContainer, String idContainer, String id) {
        new CreateNodeTool((DiagramContext)this, "exit.point", idTargetContainer, idContainer, id).run();
    }

    public void createTransition(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "transition", idSource, idTarget, id).run();
    }

    public void insertReuseModeState(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "reuse.mode.state", containerId).insert(id);
    }

    public void removeReuseModeState(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "reuse.mode.state", containerId).remove(id);
    }

    public void showStateMode(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "state.mode", containerId).insert(id);
    }

    public void hideStateMode(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "state.mode", containerId).remove(id);
    }

    public void showTransition(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "transitions", containerId).insert(id);
    }

    public void hideTransition(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "transitions", containerId).remove(id);
    }
}

