/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.sequence;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.CommonTestMessages;

public class MessageCreationTool
extends CreateDEdgeTool {
    private MessageKind messageKind = null;
    private boolean hasReturnBranch = false;
    private int numCountChecks;

    public MessageCreationTool(DiagramContext context, String toolName, String sourceId, String targetId) {
        super(context, toolName, sourceId, targetId);
        this.numCountChecks = 1;
    }

    public MessageCreationTool(DiagramContext context, String toolName, String id, String sourceId, String targetId) {
        super(context, toolName, sourceId, targetId, id);
        this.numCountChecks = 2;
    }

    public MessageCreationTool(DiagramContext context, String toolName, String id, String sourceId, String targetId, boolean returnBranch) {
        super(context, toolName, sourceId, targetId, id);
        this.hasReturnBranch = returnBranch;
        this.numCountChecks = 2;
    }

    public MessageCreationTool(DiagramContext context, String toolName, String sourceId, String targetId, MessageKind messageKind) {
        super(context, toolName, sourceId, targetId);
        this.messageKind = messageKind;
        this.numCountChecks = 2;
    }

    public MessageCreationTool(DiagramContext context, String toolName, String id, String sourceId, String targetId, MessageKind messageKind) {
        super(context, toolName, sourceId, targetId, id);
        this.messageKind = messageKind;
        this.numCountChecks = 3;
    }

    public MessageCreationTool(DiagramContext context, String toolName, String id, String sourceId, String targetId, MessageKind messageKind, boolean returnBranch) {
        this(context, toolName, sourceId, targetId, id);
        this.hasReturnBranch = returnBranch;
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
        super.preRunTest();
    }

    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                return MessageCreationTool.this.getExecutionContext().getSemanticElement(MessageCreationTool.this._newIdentifier);
            }
        };
    }

    @Override
    protected void postRunTest() {
        super.postRunTest();
        DDiagram diagram = this.getDiagramContext().getDiagram();
        DiagramHelper.refreshDiagram(diagram);
        EObject exchangeToAdd = null;
        String failMessage = "";
        if (this._newIdentifier != null) {
            exchangeToAdd = this.getExecutionContext().getSemanticElement(this._newIdentifier);
            NLS.bind((String)CommonTestMessages.objectRepresentationNotAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)exchangeToAdd), (Object)EObjectExt.getText((EObject)diagram));
        } else {
            failMessage = "Message Creation postconditions failed";
        }
        if (this._newEdgesElements.size() == this.getNoEdgesCreated()) {
            DDiagramElement view = (DDiagramElement)this._newEdgesElements.iterator().next();
            EList semanticElements = view.getSemanticElements();
            int countChecks = 0;
            for (EObject semanticElement : semanticElements) {
                if (exchangeToAdd != null && (semanticElement instanceof FunctionalExchange || semanticElement instanceof ComponentExchange || semanticElement instanceof ExchangeItemAllocation)) {
                    Assert.assertEquals((String)failMessage, (Object)exchangeToAdd, (Object)semanticElement);
                    ++countChecks;
                }
                if (semanticElement instanceof SequenceMessage) {
                    ++countChecks;
                }
                if (this.messageKind != null && semanticElement instanceof SequenceMessage) {
                    Assert.assertEquals((String)"Message Kind unexpected", (Object)this.messageKind, (Object)((SequenceMessage)semanticElement).getKind());
                    ++countChecks;
                }
                if (countChecks != this.numCountChecks) continue;
                return;
            }
        }
        Assert.fail((String)failMessage);
    }

    private int getNoEdgesCreated() {
        if (this.hasReturnBranch) {
            return 2;
        }
        return 1;
    }
}

