/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.services.commands.AbstractUiHandler;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.DiagramLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.LayoutFactory;
import org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.CompareLayoutManager;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.LayoutMatchPolicy;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CompareLayoutHandler
extends AbstractUiHandler {
    CompareLayoutManager manager = new CompareLayoutManager();

    public CompareLayoutManager getManager() {
        return this.manager;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<DRepresentationDescriptor> diagrams = new ArrayList<DRepresentationDescriptor>();
        ArrayList<IFile> layouts = new ArrayList<IFile>();
        Object[] objectArray = ((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selection = objectArray[n2];
            if (selection instanceof DRepresentationDescriptor) {
                diagrams.add((DRepresentationDescriptor)selection);
            } else if (selection instanceof ItemWrapper) {
                diagrams.add((DRepresentationDescriptor)((ItemWrapper)selection).getWrappedObject());
            } else if (selection instanceof IFile && ((IFile)selection).getFileExtension().equals("layout")) {
                layouts.add((IFile)selection);
            }
            ++n2;
        }
        this.manager = new CompareLayoutManager();
        if (diagrams.size() == 2) {
            DRepresentationDescriptor descriptor = (DRepresentationDescriptor)diagrams.get(0);
            DRepresentationDescriptor descriptor2 = (DRepresentationDescriptor)diagrams.get(1);
            this.compare(descriptor, descriptor2, true);
        } else if (diagrams.size() == 1 && layouts.size() == 1) {
            this.compare((DRepresentationDescriptor)diagrams.get(0), (IFile)layouts.get(0), true);
        } else if (layouts.size() == 2) {
            this.compare((IFile)layouts.get(0), (IFile)layouts.get(1), true);
        }
        return null;
    }

    private void compare(final DRepresentationDescriptor diagram1, IFile iFile, boolean ui) {
        Session session1 = SessionManager.INSTANCE.getSession(diagram1.getTarget());
        SessionLayout sessionLayout = LayoutFactory.eINSTANCE.createSessionLayout();
        DiagramLayout layout = this.manager.getCurrentLayout(session1, (DDiagram)diagram1.getRepresentation());
        sessionLayout.getOwnedLayouts().add((Object)layout);
        ExecutionManager emanager = ExecutionManagerRegistry.getInstance().addNewManager();
        Resource res = emanager.getEditingDomain().getResourceSet().getResource(EcoreUtil2.getURI((IFile)iFile), true);
        final SessionLayout sessionLayout2 = (SessionLayout)res.getContents().get(0);
        LayoutMatchPolicy m = new LayoutMatchPolicy();
        emanager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Iterator l = sessionLayout2.getOwnedLayouts().iterator();
                while (l.hasNext()) {
                    DiagramLayout ll = (DiagramLayout)l.next();
                    if (ll.getId().equals(((CapellaElement)diagram1.getTarget()).getId()) && ll.getName().equals(diagram1.getName())) continue;
                    l.remove();
                }
            }
        });
        if (ui) {
            this.manager.uiAnalysis(sessionLayout, sessionLayout2);
        } else {
            this.manager.analysis(sessionLayout, sessionLayout2);
        }
    }

    private void compare(IFile iFile, IFile iFile2, boolean ui) {
        ExecutionManager emanager = ExecutionManagerRegistry.getInstance().addNewManager();
        Resource res = emanager.getEditingDomain().getResourceSet().getResource(EcoreUtil2.getURI((IFile)iFile), true);
        SessionLayout sessionLayout = (SessionLayout)res.getContents().get(0);
        ExecutionManager emanager2 = ExecutionManagerRegistry.getInstance().addNewManager();
        Resource res2 = emanager2.getEditingDomain().getResourceSet().getResource(EcoreUtil2.getURI((IFile)iFile2), true);
        SessionLayout sessionLayout2 = (SessionLayout)res2.getContents().get(0);
        if (ui) {
            this.manager.uiAnalysis(sessionLayout, sessionLayout2);
        } else {
            this.manager.analysis(sessionLayout, sessionLayout2);
        }
    }

    public void copyPasteLayout(DRepresentationDescriptor diagram1, DRepresentationDescriptor diagram2) {
        Session session = SessionManager.INSTANCE.getSession(diagram1.getTarget());
        SessionContext context = new SessionContext(session);
        DiagramContext c = new DiagramContext(context, (DDiagram)diagram1.getRepresentation());
        c.open();
        DiagramHelper.copyLayout((DDiagram)c.getDiagram());
        DiagramContext c2 = new DiagramContext(context, (DDiagram)diagram2.getRepresentation());
        c2.open();
        DiagramHelper.pasteLayout((DDiagram)c2.getDiagram());
    }

    public void compare(DRepresentationDescriptor diagram1, DRepresentationDescriptor diagram2, boolean ui) {
        Session session1 = SessionManager.INSTANCE.getSession(diagram1.getTarget());
        Session session2 = SessionManager.INSTANCE.getSession(diagram2.getTarget());
        SessionLayout sessionLayout = LayoutFactory.eINSTANCE.createSessionLayout();
        DiagramLayout layout = this.manager.getCurrentLayout(session1, (DDiagram)diagram1.getRepresentation());
        sessionLayout.getOwnedLayouts().add((Object)layout);
        SessionLayout sessionLayout2 = LayoutFactory.eINSTANCE.createSessionLayout();
        DiagramLayout layout2 = this.manager.getCurrentLayout(session2, (DDiagram)diagram2.getRepresentation());
        sessionLayout2.getOwnedLayouts().add((Object)layout2);
        layout2.setId(layout.getId());
        layout2.setName(layout.getName());
        if (ui) {
            this.manager.uiAnalysis(sessionLayout, sessionLayout2);
        } else {
            this.manager.analysis(sessionLayout, sessionLayout2);
        }
    }
}

