/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.sirius.ui.listener.DAnnotationChangeTrigger;
import org.polarsys.capella.core.sirius.ui.listener.DAnnotationPrecommitListener;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DAnnotationChangeTest
extends BasicTestCase {
    public static final String OA_2 = "f26b78a9-9109-4af6-840c-fc3d050e1f8e";
    public static final String OA_4 = "308bbc45-8cda-45a2-886f-8adc208e3b7b";
    private String projectTestName = "StatusLine";
    private TestDAnnotationChangeTrigger dAnnotationChangeTrigger;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getCorePreferenceStore();
        boolean oldAutoRefreshValue = preferenceStore.getBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name());
        try {
            DiagramHelper.setPreferenceAutoRefresh((boolean)false);
            CapellaModel model = this.getTestModel(this.projectTestName);
            ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
            final EObject oa_4 = IdManager.getInstance().getEObject(OA_4, (IScope)scope);
            Session session = this.getSession(this.projectTestName);
            SessionContext context = new SessionContext(session);
            this.dAnnotationChangeTrigger = new TestDAnnotationChangeTrigger(session);
            DAnnotationPrecommitListener DAnnotationPrecommitListener2 = new DAnnotationPrecommitListener();
            session.getEventBroker().addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate)DAnnotationPrecommitListener2.considerDAnnotationForAutomaticRefreshPredicate), (ModelChangeTrigger)this.dAnnotationChangeTrigger);
            XDFBDiagram OAIBDiagram = XDFBDiagram.createDiagram((SessionContext)context, (String)OA_2);
            EList diagramElements = OAIBDiagram.getDiagram().getDiagramElements();
            DAnnotationChangeTest.assertEquals((String)"There should be 0 diagram elements displayed on this new diagram", (int)0, (int)diagramElements.size());
            DAnnotationChangeTest.assertEquals((String)"No representation refresh should have been triggered so far", (int)0, (int)this.dAnnotationChangeTrigger.getRefreshCount());
            final DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)OAIBDiagram.getDiagram()).getRepresentationDescriptor();
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    DAnnotation dAnnotation = null;
                    if (representationDescriptor.getEAnnotations().isEmpty()) {
                        dAnnotation = DescriptionFactory.eINSTANCE.createDAnnotation();
                        representationDescriptor.getEAnnotations().add((Object)dAnnotation);
                    } else {
                        dAnnotation = (DAnnotation)representationDescriptor.getEAnnotations().get(0);
                    }
                    dAnnotation.setSource("http://www.polarsys.org/capella/dannotation/ContextualElements");
                    dAnnotation.getReferences().add((Object)oa_4);
                }
            });
            diagramElements = OAIBDiagram.getDiagram().getDiagramElements();
            DAnnotationChangeTest.assertEquals((String)"There should be 3 diagram elements now displayed", (int)3, (int)diagramElements.size());
            DAnnotationChangeTest.assertTrue((String)"OA_4 should have been displayed because of the DAnnotation", (boolean)diagramElements.stream().anyMatch(diagramElement -> diagramElement.getTarget().equals(oa_4)));
            DAnnotationChangeTest.assertEquals((String)"Only 1 representation refresh should have been triggered", (int)1, (int)this.dAnnotationChangeTrigger.getRefreshCount());
            session.getEventBroker().removeLocalTrigger((ModelChangeTrigger)this.dAnnotationChangeTrigger);
            session.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            DiagramHelper.setPreferenceAutoRefresh((boolean)oldAutoRefreshValue);
        }
    }

    private class TestDAnnotationChangeTrigger
    extends DAnnotationChangeTrigger {
        private int refreshCount;

        public TestDAnnotationChangeTrigger(Session session) {
            super(session);
            this.refreshCount = 0;
        }

        public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
            LinkedHashSet representationsToRefresh = this.collectRepresentationsToRefresh(notifications);
            this.refreshCount += representationsToRefresh.size();
            return Options.newNone();
        }

        public int getRefreshCount() {
            return this.refreshCount;
        }
    }
}

