/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.fcd;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.junit.Assert;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.ReferenceHierarchyContext;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public class FCDReferenceHierarchyTest
extends AbstractDiagramTestCase {
    public static final String DIAGRAM_NAME = "[OPD] OperationalProcess 12";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_INTERACTION_1 = "8bff7379-6210-4bc2-b8a6-caeb72302eac";
    public static final String OA1_NODE_IN_OP4_Uid = "_3V6bAEDUEemAlKyHZTSwUw";
    public static final String OA1_NODE_IN_OP1_Uid = "_sZGn1kDXEemAlKyHZTSwUw";
    public static final String OA1_NODE_IN_DIAGRAM_Uid = "_1ZlRMEDUEemAlKyHZTSwUw";
    public static final String OA2_NODE_IN_OP8_Uid = "_3V83Q0DUEemAlKyHZTSwUw";
    public static final String OA2_NODE_IN_OP6_Uid = "_sZH19EDXEemAlKyHZTSwUw";
    public static final String OA2_NODE_IN_DIAGRAM_Uid = "_1Zl4QEDUEemAlKyHZTSwUw";
    public static final String FCR_TO_OP1_IN_OP4_Uid = "5a778644-c540-44e3-8f9f-bd0e4aba7dcb";
    public static final String FCR_TO_OP1_IN_DIAGRAM_Uid = "9bf142c3-33c8-4348-9a5c-be275fbcbc22";
    public static final String FCR_TO_OP6_IN_OP8_Uid = "13d0ce43-6f0f-44c7-a780-a33a8a3bbdf7";
    public static final String FCR_TO_OP6_IN_DIAGRAM_Uid = "7b82f33c-6908-45b8-a599-1a7bc835fc94";
    Session session;
    SessionContext context;
    TransactionalEditingDomain ted;
    DiagramContext diagramContext;
    DDiagram diagram;

    protected String getRequiredTestModel() {
        return "FCDCollapsingTest";
    }

    public void test() throws Exception {
        this.session = this.getSessionForTestModel(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
        this.ted = this.session.getTransactionalEditingDomain();
        this.diagramContext = (DiagramContext)new OpenDiagramStep(this.context, DIAGRAM_NAME).run();
        this.diagram = this.diagramContext.getDiagram();
        FunctionalChainInvolvementLink link = (FunctionalChainInvolvementLink)this.context.getSemanticElement(FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_INTERACTION_1);
        FunctionalChainServices functionalChainServices = FunctionalChainServices.getFunctionalChainServices();
        DDiagramElement OA1_NODE_IN_OP4 = this.findDiagramElementByUid(this.diagram, OA1_NODE_IN_OP4_Uid);
        DDiagramElement OA1_NODE_IN_OP1 = this.findDiagramElementByUid(this.diagram, OA1_NODE_IN_OP1_Uid);
        DDiagramElement OA1_NODE_IN_DIAGRAM = this.findDiagramElementByUid(this.diagram, OA1_NODE_IN_DIAGRAM_Uid);
        DDiagramElement OA2_NODE_IN_OP8 = this.findDiagramElementByUid(this.diagram, OA2_NODE_IN_OP8_Uid);
        DDiagramElement OA2_NODE_IN_OP6 = this.findDiagramElementByUid(this.diagram, OA2_NODE_IN_OP6_Uid);
        DDiagramElement OA2_NODE_IN_DIAGRAM = this.findDiagramElementByUid(this.diagram, OA2_NODE_IN_DIAGRAM_Uid);
        Assert.assertTrue((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP4, OA2_NODE_IN_OP8));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP4, OA2_NODE_IN_OP6));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP4, OA2_NODE_IN_DIAGRAM));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP1, OA2_NODE_IN_OP8));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP1, OA2_NODE_IN_OP6));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP1, OA2_NODE_IN_DIAGRAM));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_DIAGRAM, OA2_NODE_IN_OP8));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_DIAGRAM, OA2_NODE_IN_OP6));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_DIAGRAM, OA2_NODE_IN_DIAGRAM));
        DDiagramElement FCR_TO_OP1_IN_OP4 = (DDiagramElement)this.diagramContext.getView(FCR_TO_OP1_IN_OP4_Uid);
        DDiagramElement FCR_TO_OP1_IN_DIAGRAM = (DDiagramElement)this.diagramContext.getView(FCR_TO_OP1_IN_DIAGRAM_Uid);
        DDiagramElement FCR_TO_OP6_IN_OP8 = (DDiagramElement)this.diagramContext.getView(FCR_TO_OP6_IN_OP8_Uid);
        DDiagramElement FCR_TO_OP6_IN_DIAGRAM = (DDiagramElement)this.diagramContext.getView(FCR_TO_OP6_IN_DIAGRAM_Uid);
        Assert.assertTrue((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_OP4, FCR_TO_OP6_IN_OP8));
        Assert.assertTrue((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_OP4, FCR_TO_OP6_IN_OP8));
        Assert.assertTrue((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_OP4, OA2_NODE_IN_OP8));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_OP4, FCR_TO_OP6_IN_DIAGRAM));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_OP4, OA2_NODE_IN_DIAGRAM));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_DIAGRAM, FCR_TO_OP6_IN_OP8));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_DIAGRAM, FCR_TO_OP6_IN_DIAGRAM));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, FCR_TO_OP1_IN_DIAGRAM, OA2_NODE_IN_DIAGRAM));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_DIAGRAM, FCR_TO_OP6_IN_OP8));
        Assert.assertFalse((boolean)functionalChainServices.checkRefHierarchyOfLink((ReferenceHierarchyContext)link, OA1_NODE_IN_DIAGRAM, FCR_TO_OP6_IN_DIAGRAM));
    }

    public DDiagramElement findDiagramElementByUid(DDiagram diagram, String uid) {
        return diagram.getDiagramElements().stream().filter(e -> uid.equals(e.getUid())).findFirst().orElse(null);
    }
}

