/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.idb;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.IDBDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.tools.ju.idb.IDBProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ShowHideElements
extends IDBProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.init(context);
        this.testOnDiagram(context, "Interfaces Diagram Blank", "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOnDiagram(context, "Contextual Component External Interfaces", this.componentContext);
        this.testOnDiagram(context, "Contextual Component Internal Interfaces", this.componentContext);
    }

    @Override
    protected void testOnDiagram(SessionContext context, String diagramKind, String targetId) {
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)targetId);
        this.interfaces(idb);
        this.exchangeItem(idb);
        this.relationships(idb);
        if ("Interfaces Diagram Blank".equals(idb.getType())) {
            this.components(idb);
            this.actors(idb);
        }
    }

    private void components(IDBDiagram idb) {
        idb.insertComponents(new String[]{"b121dd59-9d3f-4c21-94ae-87e957aaa2a9"});
        String comp = idb.createComponent();
        idb.removeComponents(new String[]{comp});
        idb.insertComponents(new String[]{comp});
    }

    private void actors(IDBDiagram idb) {
        String actor = idb.createActor();
        idb.removeActors(new String[]{actor});
        idb.insertActors(new String[]{actor});
    }

    private void interfaces(IDBDiagram idb) {
        String interfaceId = idb.createInterface();
        idb.removeInterfaces(new String[]{interfaceId});
        idb.insertInterfaces(new String[]{interfaceId});
    }

    private void exchangeItem(IDBDiagram idb) {
        String exItem = idb.createEvent();
        idb.removeExchangeItems(new String[]{exItem});
        idb.insertExchangeItems(new String[]{exItem});
    }

    private void relationships(IDBDiagram idb) {
        String comp1 = idb.createComponent();
        String event = idb.createEvent();
        String comm = idb.createCommunicationLinkAcquire(comp1, event);
        DiagramHelper.setSynchronized((DDiagram)idb.getDiagram(), (boolean)false);
        idb.removeRelationships(comp1, new String[]{comm});
        idb.insertRelationships(comp1, new String[]{comm});
        DiagramHelper.setSynchronized((DDiagram)idb.getDiagram(), (boolean)true);
    }
}

