/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.CDBProjectSettings;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.LA_CDBProjectSettings;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.OA_CDBProjectSettings;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.PA_CDBProjectSettings;
import org.polarsys.capella.test.diagram.tools.ju.model.settings.SA_CDBProjectSettings;
import org.polarsys.capella.test.framework.context.SessionContext;

public abstract class CDBCommunication
extends AbstractDiagramTestCase {
    protected Session session;
    protected SessionContext context;
    protected CDBDiagram cdb;
    protected CDBProjectSettings settings;

    public CDBCommunication(CDBProjectSettings settings) {
        this.settings = settings;
    }

    protected void initTest() {
        this.session = this.getSession(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
    }

    public void test() throws Exception {
        this.initTest();
        this.testCDB();
        if (this.cdb != null) {
            this.cdb.close();
        }
        this.session.close((IProgressMonitor)new NullProgressMonitor());
    }

    protected abstract void testCDB();

    public String getName() {
        String architecture = "";
        if (this.settings instanceof OA_CDBProjectSettings) {
            architecture = "OA";
        } else if (this.settings instanceof SA_CDBProjectSettings) {
            architecture = "SA";
        } else if (this.settings instanceof LA_CDBProjectSettings) {
            architecture = "LA";
        } else if (this.settings instanceof PA_CDBProjectSettings) {
            architecture = "PA";
        }
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + architecture;
    }

    public String getRequiredTestModel() {
        return CDBCommunication.class.getSimpleName();
    }
}

