/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InitializeDiagramInvalidFunction
extends AbstractDiagramTestCase {
    public void test() throws Exception {
        this.checkPrecondition();
        this.checkRefresh();
        this.checkLAB();
        this.checkPAB();
    }

    private void checkPrecondition() {
        Session session = this.getSession((String)this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        XABDiagram sab = XABDiagram.openDiagram((SessionContext)context, (String)"SAB_Structure", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA);
        DSemanticDecorator view = sab.getView("03673239-0975-4eb7-bf85-86e8e2babfd0");
        SystemFunction function = (SystemFunction)context.getSemanticElement("c4fa8eff-dc88-4f1e-bd18-a0ee4502eae5");
        InitializeDiagramInvalidFunction.assertFalse((boolean)CapellaServices.getService().isAllocatedFunction((AbstractFunction)function, ((DSemanticDecorator)sab.getDiagram()).getTarget(), (DSemanticDecorator)sab.getDiagram()));
        InitializeDiagramInvalidFunction.assertTrue((boolean)CapellaServices.getService().isAllocatedFunction((AbstractFunction)function, view.getTarget(), view));
    }

    private void checkLAB() {
        Session session = this.getSession((String)this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        XABDiagram sab = XABDiagram.openDiagram((SessionContext)context, (String)"SAB_Structure", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA);
        XABDiagram lab = XABDiagram.openDiagram((SessionContext)context, (String)"LAB_Empty", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA);
        lab.initializationFromExistingDiagram((DiagramContext)sab);
        DDiagramElement system = lab.getDiagram().getOwnedDiagramElements().stream().filter(DNodeContainer.class::isInstance).findFirst().get();
        system.getName().equals("System");
        InitializeDiagramInvalidFunction.assertTrue((lab.getDiagram().getOwnedDiagramElements().stream().filter(DNode.class::isInstance).count() == 0L ? 1 : 0) != 0);
    }

    private void checkPAB() {
        Session session = this.getSession((String)this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        XABDiagram lab = XABDiagram.openDiagram((SessionContext)context, (String)"Structure", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA);
        XABDiagram pab = XABDiagram.openDiagram((SessionContext)context, (String)"PAB_Empty", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA);
        pab.initializationFromExistingDiagram((DiagramContext)lab);
        DDiagramElement system = pab.getDiagram().getOwnedDiagramElements().stream().filter(DNodeContainer.class::isInstance).findFirst().get();
        system.getName().equals("ssss");
        InitializeDiagramInvalidFunction.assertTrue((pab.getDiagram().getOwnedDiagramElements().stream().filter(DNode.class::isInstance).count() == 0L ? 1 : 0) != 0);
    }

    private void checkRefresh() {
        Session session = this.getSession((String)this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        final XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)"Broken Structure", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA);
        DDiagramElement function = diagram.getDiagram().getOwnedDiagramElements().stream().filter(DNode.class::isInstance).findFirst().get();
        if (function != null) {
            InitializeDiagramInvalidFunction.assertTrue((boolean)diagram.getDiagram().getOwnedDiagramElements().contains((Object)function));
            context.getExecutionManager().execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    DialectManager.INSTANCE.refresh((DRepresentation)diagram.getDiagram(), (IProgressMonitor)new NullProgressMonitor());
                }
            });
            InitializeDiagramInvalidFunction.assertTrue((!diagram.getDiagram().getOwnedDiagramElements().contains((Object)function) ? 1 : 0) != 0);
        }
    }

    protected void undoAllChanges() {
    }

    protected String getRequiredTestModel() {
        return "ModelFC";
    }
}

